/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmGroupIdBox
extends AbstractFullBox {
    public static final String TYPE = "grpi";
    private int gkEncryptionMethod;
    private String groupId;
    private byte[] groupKey;

    public OmaDrmGroupIdBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public void setGkEncryptionMethod(int gkEncryptionMethod) {
        this.gkEncryptionMethod = gkEncryptionMethod;
    }

    public int getGkEncryptionMethod() {
        return this.gkEncryptionMethod;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupKey(byte[] groupKey) {
        this.groupKey = groupKey;
    }

    public byte[] getGroupKey() {
        return this.groupKey;
    }

    public String getDisplayName() {
        return "OMA DRM Group ID Box";
    }

    protected long getContentSize() {
        return 5 + OmaDrmGroupIdBox.utf8StringLengthInBytes(this.groupId) + this.groupKey.length;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        int groupIdLength = in.readUInt16();
        this.gkEncryptionMethod = in.readUInt8();
        int gkLength = in.readUInt16();
        this.groupId = new String(in.read(groupIdLength), "UTF-8");
        this.groupKey = in.read(gkLength);
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt16(OmaDrmGroupIdBox.utf8StringLengthInBytes(this.groupId));
        isos.writeUInt8(this.gkEncryptionMethod);
        isos.writeUInt16(this.groupKey.length);
        isos.writeStringNoTerm(this.groupId);
        isos.write(this.groupKey);
    }

    public String toString() {
        return "OmaDrmGroupIdBox[gkEncryptionMethod=" + this.getGkEncryptionMethod() + ";groupId=" + this.getGroupId() + "]";
    }
}

