/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmIconUriBox
extends AbstractFullBox {
    public static final String TYPE = "icnu";
    private String iconUri;

    public OmaDrmIconUriBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getDisplayName() {
        return "Icon URI Box";
    }

    protected long getContentSize() {
        return OmaDrmIconUriBox.utf8StringLengthInBytes(this.iconUri);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.iconUri = in.readString((int)size - 4);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.iconUri);
    }

    public String toString() {
        return "OmaDrmIconUriBox[iconUri=" + this.getIconUri() + "]";
    }
}

