/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import com.coremedia.iso.boxes.OmaDrmAccessUnitFormatBox;
import com.coremedia.iso.boxes.odf.OmaDrmCommonHeadersBox;
import java.io.IOException;

public class OmaDrmKeyManagenentSystemBox
extends FullContainerBox {
    public static final String TYPE = "odkm";

    public OmaDrmKeyManagenentSystemBox() {
        super(TYPE);
        this.boxes = new Box[2];
    }

    public String getDisplayName() {
        return "Oma Drm Key Managenent System Box";
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        assert (this.boxes[0] instanceof OmaDrmCommonHeadersBox);
        assert (this.boxes.length == 1 || this.boxes[1] instanceof OmaDrmAccessUnitFormatBox);
    }

    public OmaDrmCommonHeadersBox getOmaDrmCommonHeadersBox() {
        return (OmaDrmCommonHeadersBox)this.boxes[0];
    }

    public OmaDrmAccessUnitFormatBox getDrmAccessUnitFormatBox() {
        if (this.boxes.length < 2) {
            OmaDrmAccessUnitFormatBox box = new OmaDrmAccessUnitFormatBox();
            box.setAllBits((byte)1);
            box.setKeyIndicatorLength(0);
            box.setInitVectorLength(16);
            return box;
        }
        return (OmaDrmAccessUnitFormatBox)this.boxes[1];
    }

    public void setOmaDrmCommonHeadersBox(OmaDrmCommonHeadersBox box) {
        this.boxes[0] = box;
    }

    public void setDrmAccessUnitFormatBox(OmaDrmAccessUnitFormatBox box) {
        this.boxes[1] = box;
    }
}

