/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmLyricsUriBox
extends AbstractFullBox {
    public static final String TYPE = "lrcu";
    private String lyricsUri;

    public OmaDrmLyricsUriBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLyricsUri() {
        return this.lyricsUri;
    }

    public String getDisplayName() {
        return "Lyrics URI Box";
    }

    protected long getContentSize() {
        return OmaDrmLyricsUriBox.utf8StringLengthInBytes(this.lyricsUri);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.lyricsUri = in.readString((int)(size - 4L));
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.lyricsUri);
    }

    public String toString() {
        return "OmaDrmLyricsUriBox[lyricsUri=" + this.getLyricsUri() + "]";
    }
}

