/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmTransactionTrackingBox
extends AbstractFullBox {
    public static final String TYPE = "odtt";
    private byte[] transactionId = new byte[16];

    public OmaDrmTransactionTrackingBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public void setTransactionId(byte[] transactionId) {
        assert (transactionId.length == 16);
        this.transactionId = transactionId;
    }

    public byte[] getTransactionId() {
        return this.transactionId;
    }

    public String getDisplayName() {
        return "OMA DRM Tranaction Tracking Box";
    }

    protected long getContentSize() {
        return 16L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        int a = in.read(this.transactionId);
        assert (a == 16);
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(this.transactionId);
    }

    public String toString() {
        return "OmaDrmTransactionTrackingBox[transactionId=" + this.getTransactionId() + "]";
    }
}

