/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "rtp ";
    private int hintTrackVersion;
    private int highestCompatibleVersion;
    private long maxPacketSize;

    public HintSampleEntry(byte[] type) {
        super(type);
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.boxes) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    public int getHintTrackVersion() {
        return this.hintTrackVersion;
    }

    public int getHighestCompatibleVersion() {
        return this.highestCompatibleVersion;
    }

    public long getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @Override
    protected long getContentSize() {
        long contentLength = 0L;
        for (Box box : this.boxes) {
            contentLength += box.getSize();
        }
        return 16L + contentLength;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.hintTrackVersion = in.readUInt16();
        this.highestCompatibleVersion = in.readUInt16();
        this.maxPacketSize = in.readUInt32();
        size -= 16L;
        LinkedList<Box> boxes = new LinkedList<Box>();
        while (size > 0L) {
            Box box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            size -= box.getSize();
            boxes.add(box);
        }
        this.boxes = boxes.toArray(new AbstractBox[0]);
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt16(this.hintTrackVersion);
        isos.writeUInt16(this.highestCompatibleVersion);
        isos.writeUInt32(this.maxPacketSize);
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }

    @Override
    public String getDisplayName() {
        return "Hint Samply Entry";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HintSampleEntry[");
        buffer.append("hintTrackVersion=").append(this.getHintTrackVersion()).append(";");
        buffer.append("highestCompatibleVersion=").append(this.getHighestCompatibleVersion()).append(";");
        buffer.append("maxPacketSize=").append(this.getMaxPacketSize());
        Box[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(boxes[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

