/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Arrays;

public class HintStatisticBoxes
extends AbstractBox {
    private long bytesSent;
    public static final String TYPE1 = "trpy";
    public static final String TYPE2 = "totl";
    public static final String TYPE3 = "tpyl";
    public static final String TYPE4 = "tpay";
    public static final String TYPE5 = "dmed";
    public static final String TYPE6 = "dimm";
    public static final String TYPE7 = "drep";

    public HintStatisticBoxes(byte[] type) {
        super(type);
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public String getDisplayName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Hint Bytes Sent Box (");
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2))) {
            buffer.append("including 12-byte RTP headers");
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            buffer.append("not including RTP headers");
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5))) {
            buffer.append("total bytes sent from media tracks");
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6))) {
            buffer.append("total bytes sent immediate mode");
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7))) {
            buffer.append("total bytes in repeated packets");
        } else {
            throw new UnsupportedOperationException();
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected long getContentSize() {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3))) {
            return 8L;
        }
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            return 4L;
        }
        throw new UnsupportedOperationException();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7))) {
            isos.writeUInt64(this.bytesSent);
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            isos.writeUInt32((int)this.bytesSent);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE3)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE5)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE6)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE7))) {
            this.bytesSent = in.readUInt64();
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2)) || Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE4))) {
            this.bytesSent = in.readUInt32();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String toString() {
        return "HintStatistic[type=" + IsoFile.bytesToFourCC(this.getType()) + ";bytes=" + Long.toHexString(this.bytesSent) + "]";
    }
}

