/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class LargestHintPacketBox
extends AbstractBox {
    public static final String TYPE = "pmax";
    private long maxSize;

    public LargestHintPacketBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.maxSize = in.readUInt32();
    }

    public String getDisplayName() {
        return "Largest Hint Packet";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.maxSize);
    }

    public long getmaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

