/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.assistui.multiline;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class RtpMovieHintInformationBox
extends AbstractBox {
    public static final String TYPE = "rtp ";
    private String descriptionFormat;
    @multiline(linebreak="\r\n")
    private String sdpText;

    public RtpMovieHintInformationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public String getSdpText() {
        return this.sdpText;
    }

    public void setDescriptionFormat(String descriptionFormat) {
        this.descriptionFormat = descriptionFormat;
    }

    public void setSdpText(String sdpText) {
        this.sdpText = sdpText;
    }

    public String getDisplayName() {
        return "RTP Movie Hint Information";
    }

    protected long getContentSize() {
        return RtpMovieHintInformationBox.utf8StringLengthInBytes(this.sdpText) + 4;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.descriptionFormat = IsoFile.bytesToFourCC(in.read(4));
        this.sdpText = in.readString((int)size - 4);
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.descriptionFormat));
        isos.writeStringNoTerm(this.sdpText);
    }

    public String toString() {
        return "RtpMovieHintInformationBox[descriptionFormat=" + this.getDescriptionFormat() + ";sdpText=" + this.getSdpText() + "]";
    }
}

