/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.assistui.multiline;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class RtpTrackSdpHintInformationBox
extends AbstractBox {
    public static final String TYPE = "sdp ";
    @multiline(linebreak="\r\n")
    private String sdpText;

    protected long getContentSize() {
        return RtpTrackSdpHintInformationBox.utf8StringLengthInBytes(this.sdpText);
    }

    public RtpTrackSdpHintInformationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getSdpText() {
        return this.sdpText;
    }

    public void setSdpText(String sdpText) {
        this.sdpText = sdpText;
    }

    public String getDisplayName() {
        return "RTP Track SDP Hint Information";
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.sdpText = new String(in.read((int)size), "UTF-8");
    }

    public String toString() {
        return "RtpTrackSdpHintInformationBox[sdpText=" + this.getSdpText() + "]";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.sdpText);
    }
}

