/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class TimeScaleEntry
extends AbstractBox {
    private long timescale;
    public static final String TYPE = "tims";

    public TimeScaleEntry() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getTimescale() {
        return this.timescale;
    }

    public String getDisplayName() {
        return "Time Scale Entry";
    }

    protected long getContentSize() {
        return 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        assert (size == 4L);
        this.timescale = in.readUInt32();
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.timescale);
    }

    public String toString() {
        return "TimeScaleEntry[timescale=" + this.getTimescale() + "]";
    }
}

