/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AmrSpecificBox
extends AbstractBox {
    public static final String TYPE = "damr";
    private String vendor;
    private int decoderVersion;
    private int modeSet;
    private int modeChangePeriod;
    private int framesPerSample;

    public AmrSpecificBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getDecoderVersion() {
        return this.decoderVersion;
    }

    public int getModeSet() {
        return this.modeSet;
    }

    public int getModeChangePeriod() {
        return this.modeChangePeriod;
    }

    public int getFramesPerSample() {
        return this.framesPerSample;
    }

    public String getDisplayName() {
        return "AMR Specific Box";
    }

    protected long getContentSize() {
        return 9L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        assert (size == 9L);
        this.vendor = IsoFile.bytesToFourCC(in.read(4));
        this.decoderVersion = in.readUInt8();
        this.modeSet = in.readUInt16();
        this.modeChangePeriod = in.readUInt8();
        this.framesPerSample = in.readUInt8();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.vendor));
        isos.writeUInt8(this.decoderVersion);
        isos.writeUInt16(this.modeSet);
        isos.writeUInt8(this.modeChangePeriod);
        isos.writeUInt8(this.framesPerSample);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AmrSpecificBox[vendor=").append(this.getVendor());
        buffer.append(";decoderVersion=").append(this.getDecoderVersion());
        buffer.append(";modeSet=").append(this.getModeSet());
        buffer.append(";modeChangePeriod=").append(this.getModeChangePeriod());
        buffer.append(";framesPerSample=").append(this.getFramesPerSample());
        buffer.append("]");
        return buffer.toString();
    }
}

