/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "samr";
    public static final String TYPE2 = "sawb";
    public static final String TYPE3 = "mp4a";
    public static final String TYPE4 = "drms";
    public static final String TYPE5 = "alac";
    public static final String TYPE7 = "owma";
    public static final String TYPE8 = "ac-3";
    public static final String TYPE_ENCRYPTED = "enca";
    private int channelCount;
    private int sampleSize;
    private double sampleRate;
    private int soundVersion;
    private int compressionId;
    private int packetSize;
    private long samplesPerPacket;
    private long bytesPerPacket;
    private long bytesPerFrame;
    private long bytesPerSample;

    public AudioSampleEntry(byte[] type) {
        super(type);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSoundVersion() {
        return this.soundVersion;
    }

    public int getCompressionId() {
        return this.compressionId;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public long getSamplesPerPacket() {
        return this.samplesPerPacket;
    }

    public long getBytesPerPacket() {
        return this.bytesPerPacket;
    }

    public long getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public long getBytesPerSample() {
        return this.bytesPerSample;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.soundVersion = in.readUInt16();
        in.readUInt16();
        in.readUInt32();
        this.channelCount = in.readUInt16();
        this.sampleSize = in.readUInt16();
        this.compressionId = in.readUInt16();
        this.packetSize = in.readUInt16();
        this.sampleRate = in.readFixedPoint1616();
        if (this.soundVersion > 0) {
            this.samplesPerPacket = in.readUInt32();
            this.bytesPerPacket = in.readUInt32();
            this.bytesPerFrame = in.readUInt32();
            this.bytesPerSample = in.readUInt32();
        }
        if (this.soundVersion == 2) {
            in.read(20);
        }
        size -= 28L;
        ArrayList<Box> someBoxes = new ArrayList<Box>();
        while (size > 8L && !TYPE7.equals(IsoFile.bytesToFourCC(this.type))) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            someBoxes.add(b);
            size -= b.getSize();
        }
        this.boxes = someBoxes.toArray(new Box[someBoxes.size()]);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.boxes) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 28L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    @Override
    public String getDisplayName() {
        return "Audio Sample Entry";
    }

    public String toString() {
        return "AudioSampleEntry";
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt32(0L);
        isos.writeUInt32(0L);
        isos.writeUInt16(this.getChannelCount());
        isos.writeUInt16(this.getSampleSize());
        isos.writeUInt16(0);
        isos.writeUInt16(0);
        isos.writeFixedPont1616(this.getSampleRate());
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

