/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpegSampleEntry
extends SampleEntry
implements ContainerBox {
    public MpegSampleEntry(byte[] type) {
        super(type);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        ArrayList<Box> someBoxes = new ArrayList<Box>();
        while (size > 8L) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            someBoxes.add(b);
            size -= b.getSize();
        }
        this.boxes = someBoxes.toArray(new Box[someBoxes.size()]);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.boxes) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 8L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    @Override
    public String getDisplayName() {
        return "Mpeg Sample Entry";
    }

    public String toString() {
        return "MpegSampleEntry" + Arrays.asList(this.getBoxes());
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

