/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SampleEntry
extends AbstractBox
implements ContainerBox {
    private int dataReferenceIndex;
    protected Box[] boxes = new Box[0];
    byte[] type;

    protected SampleEntry(byte[] type) {
        super(type);
        this.type = type;
    }

    @Override
    public byte[] getType() {
        return this.type;
    }

    public void setType(byte[] type) {
        this.type = type;
    }

    public int getDataReferenceIndex() {
        return this.dataReferenceIndex;
    }

    public void addBox(AbstractBox b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        listOfBoxes.add(b);
        this.boxes = listOfBoxes.toArray(new AbstractBox[listOfBoxes.size()]);
    }

    public boolean removeBox(Box b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        boolean rc = listOfBoxes.remove(b);
        this.boxes = listOfBoxes.toArray(new Box[listOfBoxes.size()]);
        return rc;
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(Arrays.asList(((ContainerBox)boxe).getBoxes(clazz, recursive)));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        byte[] tmp = in.read(6);
        assert (Arrays.equals(new byte[6], tmp)) : "reserved byte not 0";
        this.dataReferenceIndex = in.readUInt16();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box box : this.boxes) {
            sizeOfChildren += box.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

