/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private long displayFlags;
    private int horizontalJustification;
    private int verticalJustification;
    private byte[] backgroundColorRgba;

    public TextSampleEntry(byte[] type) {
        super(type);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.displayFlags = in.readUInt32();
        this.horizontalJustification = in.readUInt8();
        this.verticalJustification = in.readUInt8();
        this.backgroundColorRgba[0] = (byte)in.readUInt8();
        this.backgroundColorRgba[1] = (byte)in.readUInt8();
        this.backgroundColorRgba[2] = (byte)in.readUInt8();
        this.backgroundColorRgba[3] = (byte)in.readUInt8();
        size -= 18L;
        ArrayList<Box> someBoxes = new ArrayList<Box>();
        while (size > 0L) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            someBoxes.add(b);
            size -= b.getSize();
        }
        this.boxes = someBoxes.toArray(new AbstractBox[someBoxes.size()]);
        assert (size == 0L) : "After parsing all boxes there are " + size + " bytes left. 0 bytes required";
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.boxes) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 18L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    @Override
    public String getDisplayName() {
        return "Text Sample Entry";
    }

    public String toString() {
        return "TextSampleEntry";
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt32(this.displayFlags);
        isos.writeUInt8(this.horizontalJustification);
        isos.writeUInt8(this.verticalJustification);
        isos.writeUInt8(this.backgroundColorRgba[0]);
        isos.writeUInt8(this.backgroundColorRgba[1]);
        isos.writeUInt8(this.backgroundColorRgba[2]);
        isos.writeUInt8(this.backgroundColorRgba[3]);
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

