/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.threegpp26244;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class LocationInformationBox
extends AbstractFullBox {
    public static final String TYPE = "loci";
    private String language;
    private String name = "";
    private int role;
    private double longitude;
    private double latitude;
    private double altitude;
    private String astronomicalBody = "";
    private String additionalNotes = "";

    public LocationInformationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public String getAstronomicalBody() {
        return this.astronomicalBody;
    }

    public void setAstronomicalBody(String astronomicalBody) {
        this.astronomicalBody = astronomicalBody;
    }

    public String getAdditionalNotes() {
        return this.additionalNotes;
    }

    public void setAdditionalNotes(String additionalNotes) {
        this.additionalNotes = additionalNotes;
    }

    public String getDisplayName() {
        return "Location Information Box";
    }

    protected long getContentSize() {
        return 18 + Utf8.convert(this.name).length + Utf8.convert(this.astronomicalBody).length + Utf8.convert(this.additionalNotes).length;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.name = in.readString();
        this.role = in.readUInt8();
        this.longitude = in.readFixedPoint1616();
        this.latitude = in.readFixedPoint1616();
        this.altitude = in.readFixedPoint1616();
        this.astronomicalBody = in.readString();
        this.additionalNotes = in.readString();
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeIso639(this.language);
        os.writeStringZeroTerm(this.name);
        os.writeUInt8(this.role);
        os.writeFixedPont1616(this.longitude);
        os.writeFixedPont1616(this.latitude);
        os.writeFixedPont1616(this.altitude);
        os.writeStringZeroTerm(this.astronomicalBody);
        os.writeStringZeroTerm(this.additionalNotes);
    }
}

