/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.vodafone;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class LyricsUriBox
extends AbstractFullBox {
    public static final String TYPE = "lrcu";
    private String lyricsUri;

    public LyricsUriBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLyricsUri() {
        return this.lyricsUri;
    }

    public void setLyricsUri(String lyricsUri) {
        this.lyricsUri = lyricsUri;
    }

    public String getDisplayName() {
        return "Lyrics URI Box";
    }

    protected long getContentSize() {
        return LyricsUriBox.utf8StringLengthInBytes(this.lyricsUri) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.lyricsUri = in.readString((int)(size - 4L));
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringZeroTerm(this.lyricsUri);
    }

    public String toString() {
        return "LyricsUriBox[lyricsUri=" + this.getLyricsUri() + "]";
    }
}

