/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.mdta;

import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import com.coremedia.iso.mdta.Sample;
import com.coremedia.iso.mdta.Track;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk<T extends TrackMetaDataContainer> {
    List<MediaDataBox.SampleHolder<T>> samplesHolders;
    private Track<T> parentTrack;
    private MediaDataBox<T> parentMediaDataBox;

    public Chunk(Track<T> parentTrack, MediaDataBox<T> parentMediaDataBox, int expectedNumberOfSamples) {
        this.samplesHolders = new ArrayList<MediaDataBox.SampleHolder<T>>(expectedNumberOfSamples);
        this.parentTrack = parentTrack;
        this.parentMediaDataBox = parentMediaDataBox;
    }

    public void addSample(MediaDataBox.SampleHolder<T> sample) {
        this.samplesHolders.add(sample);
    }

    public List<Sample<T>> getSamples() {
        ArrayList<Sample<T>> al = new ArrayList<Sample<T>>(this.samplesHolders.size());
        for (MediaDataBox.SampleHolder<T> sampleHolder : this.samplesHolders) {
            al.add(sampleHolder.getSample());
        }
        return al;
    }

    public long getSize() {
        long length = 0L;
        int listLength = this.samplesHolders.size();
        for (int i = 0; i < listLength; ++i) {
            Sample<T> currentSample = this.samplesHolders.get(i).getSample();
            long size = currentSample.getSize();
            assert ((long)this.getSizeByWriting(currentSample) == size) : "Size of all samples accumulated is different from the size when written";
            length += size;
        }
        return length;
    }

    private int getSizeByWriting(Sample<T> currentSample) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            currentSample.getContent(new IsoOutputStream(baos));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.size();
    }

    public Track<T> getParentTrack() {
        return this.parentTrack;
    }

    public MediaDataBox<T> getParentMediaDataBox() {
        return this.parentMediaDataBox;
    }

    public Sample<T> getFirstSample() {
        return this.samplesHolders.get(0).getSample();
    }

    public long calculateOffset() {
        long offsetFromMediaDataBoxStart = this.getParentMediaDataBox().getHeader().length + this.getParentMediaDataBox().getDeadBytesBefore().length;
        Sample<T> firstSample = this.getSamples().get(0);
        int i = 0;
        while ((long)i < this.parentMediaDataBox.getSampleCount()) {
            Sample<T> currentSample = this.parentMediaDataBox.getSample(i);
            if (firstSample == currentSample) {
                return offsetFromMediaDataBoxStart;
            }
            offsetFromMediaDataBoxStart += currentSample.getSize();
            ++i;
        }
        throw new RuntimeException("Could not find myself...");
    }

    public String toString() {
        return "Chunk{parentTrack=" + this.parentTrack + "; offset=" + this.calculateOffset() + '}';
    }
}

