/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.mdta;

import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.Sample;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SampleImpl<T extends TrackMetaDataContainer>
implements Sample<T>,
Comparable<SampleImpl<T>> {
    private final Chunk<T> parent;
    private final IsoBufferWrapper buffer;
    private final long offset;
    private final long size;
    private boolean syncSample;

    public SampleImpl(IsoBufferWrapper buffer, long offset, long size, Chunk<T> parent, boolean syncSample) {
        this.parent = parent;
        this.buffer = buffer;
        this.offset = offset;
        this.size = size;
        this.syncSample = syncSample;
    }

    @Override
    public void getContent(IsoOutputStream os) throws IOException {
        ByteBuffer[] segments;
        for (ByteBuffer segment : segments = this.buffer.getSegment(this.offset, this.size)) {
            while (segment.remaining() > 1024) {
                byte[] buf = new byte[1024];
                segment.get(buf);
                os.write(buf);
            }
            while (segment.remaining() > 0) {
                os.write(segment.get());
            }
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Offset: " + this.calculateOffset() + " Size: " + this.size + " Chunk: " + this.parent.getFirstSample().calculateOffset() + " Track: " + this.parent.getParentTrack().getTrackId() + " SyncSample: " + this.syncSample;
    }

    @Override
    public int compareTo(SampleImpl<T> o) {
        return (int)(this.offset - o.offset);
    }

    @Override
    public Chunk<T> getParent() {
        return this.parent;
    }

    @Override
    public long calculateOffset() {
        long offsetFromChunkStart = 0L;
        List<Sample<T>> samples = this.parent.getSamples();
        for (Sample<T> sample : samples) {
            if (this.equals(sample)) continue;
            offsetFromChunkStart += sample.getSize();
        }
        return this.parent.calculateOffset() + offsetFromChunkStart;
    }

    @Override
    public boolean isSyncSample() {
        return this.syncSample;
    }
}

