/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.mdta;

import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.TrackMetaData;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import com.coremedia.iso.mdta.Chunk;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track<T extends TrackMetaDataContainer>
implements Comparable<Track<T>> {
    private final long trackId;
    private final TrackMetaData<T> trackMetaData;
    private MediaDataBox<? extends TrackMetaDataContainer> mediaDataBox;
    private List<Chunk<T>> chunks = new LinkedList<Chunk<T>>();

    public Track(long index, TrackMetaData<T> trackBox, MediaDataBox<? extends TrackMetaDataContainer> mediaDataBox) {
        this.trackId = index;
        this.trackMetaData = trackBox;
        this.mediaDataBox = mediaDataBox;
    }

    public final long getTrackId() {
        return this.trackId;
    }

    public List<Chunk<T>> getChunks() {
        return new ArrayList<Chunk<T>>(this.chunks);
    }

    public TrackMetaData<T> getTrackMetaData() {
        return this.trackMetaData;
    }

    public MediaDataBox<? extends TrackMetaDataContainer> getMediaDataBox() {
        return this.mediaDataBox;
    }

    public void addChunk(Chunk<T> chunk) {
        this.chunks.add(chunk);
    }

    public long getSize() {
        long size = 0L;
        for (Chunk<T> chunk : this.chunks) {
            size += chunk.getSize();
        }
        return size;
    }

    @Override
    public int compareTo(Track<T> o) {
        return this.getTrackId() < o.getTrackId() ? -1 : (this.getTrackId() == o.getTrackId() ? 0 : 1);
    }

    public String toString() {
        return "Track{trackId=" + this.trackId + '}';
    }
}

