/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.HandlerBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerBox
extends AbstractBox
implements ContainerBox {
    protected List<Box> boxes = new LinkedList<Box>();

    @Override
    protected long getContentSize() {
        long contentSize = 0L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public AbstractContainerBox(byte[] type) {
        super(type);
    }

    @Override
    public List<Box> getBoxes() {
        return Collections.unmodifiableList(this.boxes);
    }

    @Override
    public void setBoxes(List<Box> boxes) {
        this.boxes = new LinkedList<Box>(boxes);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(((ContainerBox)boxe).getBoxes(clazz, recursive));
        }
        return boxesToBeReturned;
    }

    public void addBox(Box b) {
        b.setParent(this);
        this.boxes.add(b);
    }

    public void removeBox(Box b) {
        this.boxes.remove(b);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        while (size >= 8L) {
            long sp = in.position();
            Box box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            long parsedBytes = in.position() - sp;
            assert (parsedBytes == box.getSize() || box instanceof HandlerBox) : box + " didn't parse well. number of parsed bytes (" + parsedBytes + ") doesn't match getSize (" + box.getSize() + ")";
            size -= parsedBytes;
            this.boxes.add(box);
        }
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Box boxe : this.boxes) {
            boxe.getBox(os);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes.get(i).toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return 8L;
    }
}

