/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleAuxiliaryInformationSizesBox
extends AbstractFullBox {
    public static final String TYPE = "saiz";
    private short defaultSampleInfoSize;
    private long sampleCount;
    private List<Short> sampleInfoSizes = new LinkedList<Short>();
    private long auxInfoType;
    private long auxInfoTypeParameter;

    public SampleAuxiliaryInformationSizesBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return (long)(5 + ((this.getFlags() & 1) == 1 ? 8 : 0)) + (this.defaultSampleInfoSize == 0 ? this.sampleCount : 0L);
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        if ((this.getFlags() & 1) == 1) {
            os.writeUInt32(this.auxInfoType);
            os.writeUInt32(this.auxInfoTypeParameter);
        }
        os.writeUInt8(this.defaultSampleInfoSize);
        os.writeUInt32(this.sampleCount);
        for (short sampleInfoSize : this.sampleInfoSizes) {
            os.writeUInt8(sampleInfoSize);
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if ((this.getFlags() & 1) == 1) {
            this.auxInfoType = in.readUInt32();
            this.auxInfoTypeParameter = in.readUInt32();
        }
        this.defaultSampleInfoSize = (short)in.readUInt8();
        this.sampleCount = in.readUInt32();
        this.sampleInfoSizes.clear();
        if (this.defaultSampleInfoSize == 0) {
            int i = 0;
            while ((long)i < this.sampleCount) {
                this.sampleInfoSizes.add((short)in.readUInt8());
                ++i;
            }
        }
    }

    public long getAuxInfoType() {
        return this.auxInfoType;
    }

    public void setAuxInfoType(long auxInfoType) {
        this.auxInfoType = auxInfoType;
    }

    public long getAuxInfoTypeParameter() {
        return this.auxInfoTypeParameter;
    }

    public void setAuxInfoTypeParameter(long auxInfoTypeParameter) {
        this.auxInfoTypeParameter = auxInfoTypeParameter;
    }

    public short getDefaultSampleInfoSize() {
        return this.defaultSampleInfoSize;
    }

    public void setDefaultSampleInfoSize(short defaultSampleInfoSize) {
        this.defaultSampleInfoSize = defaultSampleInfoSize;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(long sampleCount) {
        this.sampleCount = sampleCount;
    }

    public List<Short> getSampleInfoSizes() {
        return this.sampleInfoSizes;
    }

    public void setSampleInfoSizes(List<Short> sampleInfoSizes) {
        this.sampleInfoSizes = sampleInfoSizes;
    }
}

