/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import java.io.IOException;

public class TrackBox
extends AbstractContainerBox
implements TrackMetaDataContainer {
    public static final String TYPE = "trak";

    public TrackBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public TrackHeaderBox getTrackHeaderBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof TrackHeaderBox)) continue;
            return (TrackHeaderBox)box;
        }
        return null;
    }

    public SampleTableBox getSampleTableBox() {
        MediaInformationBox minf;
        MediaBox mdia = this.getMediaBox();
        if (mdia != null && (minf = mdia.getMediaInformationBox()) != null) {
            return minf.getSampleTableBox();
        }
        return null;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
    }

    public MediaBox getMediaBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MediaBox)) continue;
            return (MediaBox)box;
        }
        return null;
    }
}

