/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.AbstractDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendTrack
extends AbstractTrack {
    private static Logger LOG = Logger.getLogger(AppendTrack.class);
    Track[] tracks;
    SampleDescriptionBox stsd;

    public static String appendTracknames(Track ... tracks) {
        String name = "";
        Track[] trackArray = tracks;
        int n = tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            name = String.valueOf(name) + track.getName() + " + ";
            ++n2;
        }
        return name.substring(0, name.length() - 3);
    }

    public AppendTrack(Track ... tracks) throws IOException {
        super(AppendTrack.appendTracknames(tracks));
        this.tracks = tracks;
        Track[] trackArray = tracks;
        int n = tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            if (this.stsd == null) {
                this.stsd = new SampleDescriptionBox();
                this.stsd.addBox(track.getSampleDescriptionBox().getBoxes(SampleEntry.class).get(0));
            } else {
                this.stsd = this.mergeStsds(this.stsd, track.getSampleDescriptionBox());
            }
            ++n2;
        }
    }

    @Override
    public void close() throws IOException {
        Track[] trackArray = this.tracks;
        int n = this.tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            track.close();
            ++n2;
        }
    }

    private SampleDescriptionBox mergeStsds(SampleDescriptionBox stsd1, SampleDescriptionBox stsd2) throws IOException {
        ByteArrayOutputStream curBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream refBaos = new ByteArrayOutputStream();
        try {
            stsd1.getBox(Channels.newChannel(curBaos));
            stsd2.getBox(Channels.newChannel(refBaos));
        }
        catch (IOException e) {
            LOG.logError(e.getMessage());
            return null;
        }
        byte[] cur = curBaos.toByteArray();
        byte[] ref = refBaos.toByteArray();
        if (!Arrays.equals(ref, cur)) {
            SampleEntry se = this.mergeSampleEntry(stsd1.getBoxes(SampleEntry.class).get(0), stsd2.getBoxes(SampleEntry.class).get(0));
            if (se != null) {
                stsd1.setBoxes(Collections.singletonList(se));
            } else {
                throw new IOException("Cannot merge " + stsd1.getBoxes(SampleEntry.class).get(0) + " and " + stsd2.getBoxes(SampleEntry.class).get(0));
            }
        }
        return stsd1;
    }

    private SampleEntry mergeSampleEntry(SampleEntry se1, SampleEntry se2) {
        if (!se1.getType().equals(se2.getType())) {
            return null;
        }
        if (se1 instanceof VisualSampleEntry && se2 instanceof VisualSampleEntry) {
            return this.mergeVisualSampleEntry((VisualSampleEntry)se1, (VisualSampleEntry)se2);
        }
        if (se1 instanceof AudioSampleEntry && se2 instanceof AudioSampleEntry) {
            return this.mergeAudioSampleEntries((AudioSampleEntry)se1, (AudioSampleEntry)se2);
        }
        return null;
    }

    private VisualSampleEntry mergeVisualSampleEntry(VisualSampleEntry vse1, VisualSampleEntry vse2) {
        VisualSampleEntry vse = new VisualSampleEntry();
        if (vse1.getHorizresolution() != vse2.getHorizresolution()) {
            LOG.logError("Horizontal Resolution differs");
            return null;
        }
        vse.setHorizresolution(vse1.getHorizresolution());
        vse.setCompressorname(vse1.getCompressorname());
        if (vse1.getDepth() != vse2.getDepth()) {
            LOG.logError("Depth differs");
            return null;
        }
        vse.setDepth(vse1.getDepth());
        if (vse1.getFrameCount() != vse2.getFrameCount()) {
            LOG.logError("frame count differs");
            return null;
        }
        vse.setFrameCount(vse1.getFrameCount());
        if (vse1.getHeight() != vse2.getHeight()) {
            LOG.logError("height differs");
            return null;
        }
        vse.setHeight(vse1.getHeight());
        if (vse1.getWidth() != vse2.getWidth()) {
            LOG.logError("width differs");
            return null;
        }
        vse.setWidth(vse1.getWidth());
        if (vse1.getVertresolution() != vse2.getVertresolution()) {
            LOG.logError("vert resolution differs");
            return null;
        }
        vse.setVertresolution(vse1.getVertresolution());
        if (vse1.getHorizresolution() != vse2.getHorizresolution()) {
            LOG.logError("horizontal resolution differs");
            return null;
        }
        vse.setHorizresolution(vse1.getHorizresolution());
        if (vse1.getBoxes().size() == vse2.getBoxes().size()) {
            Iterator<Box> bxs1 = vse1.getBoxes().iterator();
            Iterator<Box> bxs2 = vse2.getBoxes().iterator();
            while (bxs1.hasNext()) {
                Box cur1 = bxs1.next();
                Box cur2 = bxs2.next();
                ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                try {
                    cur1.getBox(Channels.newChannel(baos1));
                    cur2.getBox(Channels.newChannel(baos2));
                }
                catch (IOException e) {
                    LOG.logWarn(e.getMessage());
                    return null;
                }
                if (Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
                    vse.addBox(cur1);
                    continue;
                }
                if (!(cur1 instanceof AbstractDescriptorBox) || !(cur2 instanceof AbstractDescriptorBox)) continue;
                ESDescriptor esd = this.mergeDescriptors(((AbstractDescriptorBox)cur1).getDescriptor(), ((AbstractDescriptorBox)cur2).getDescriptor());
                ((AbstractDescriptorBox)cur1).setDescriptor(esd);
                vse.addBox(cur1);
            }
        }
        return vse;
    }

    private AudioSampleEntry mergeAudioSampleEntries(AudioSampleEntry ase1, AudioSampleEntry ase2) {
        AudioSampleEntry ase = new AudioSampleEntry(ase2.getType());
        if (ase1.getBytesPerFrame() != ase2.getBytesPerFrame()) {
            LOG.logError("BytesPerFrame differ");
            return null;
        }
        ase.setBytesPerFrame(ase1.getBytesPerFrame());
        if (ase1.getBytesPerPacket() != ase2.getBytesPerPacket()) {
            return null;
        }
        ase.setBytesPerPacket(ase1.getBytesPerPacket());
        if (ase1.getBytesPerSample() != ase2.getBytesPerSample()) {
            LOG.logError("BytesPerSample differ");
            return null;
        }
        ase.setBytesPerSample(ase1.getBytesPerSample());
        if (ase1.getChannelCount() != ase2.getChannelCount()) {
            return null;
        }
        ase.setChannelCount(ase1.getChannelCount());
        if (ase1.getPacketSize() != ase2.getPacketSize()) {
            LOG.logError("ChannelCount differ");
            return null;
        }
        ase.setPacketSize(ase1.getPacketSize());
        if (ase1.getCompressionId() != ase2.getCompressionId()) {
            return null;
        }
        ase.setCompressionId(ase1.getCompressionId());
        if (ase1.getSampleRate() != ase2.getSampleRate()) {
            return null;
        }
        ase.setSampleRate(ase1.getSampleRate());
        if (ase1.getSampleSize() != ase2.getSampleSize()) {
            return null;
        }
        ase.setSampleSize(ase1.getSampleSize());
        if (ase1.getSamplesPerPacket() != ase2.getSamplesPerPacket()) {
            return null;
        }
        ase.setSamplesPerPacket(ase1.getSamplesPerPacket());
        if (ase1.getSoundVersion() != ase2.getSoundVersion()) {
            return null;
        }
        ase.setSoundVersion(ase1.getSoundVersion());
        if (!Arrays.equals(ase1.getSoundVersion2Data(), ase2.getSoundVersion2Data())) {
            return null;
        }
        ase.setSoundVersion2Data(ase1.getSoundVersion2Data());
        if (ase1.getBoxes().size() == ase2.getBoxes().size()) {
            Iterator<Box> bxs1 = ase1.getBoxes().iterator();
            Iterator<Box> bxs2 = ase2.getBoxes().iterator();
            while (bxs1.hasNext()) {
                Box cur1 = bxs1.next();
                Box cur2 = bxs2.next();
                ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                try {
                    cur1.getBox(Channels.newChannel(baos1));
                    cur2.getBox(Channels.newChannel(baos2));
                }
                catch (IOException e) {
                    LOG.logWarn(e.getMessage());
                    return null;
                }
                if (Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
                    ase.addBox(cur1);
                    continue;
                }
                if (!"esds".equals(cur1.getType()) || !"esds".equals(cur2.getType())) continue;
                ESDescriptorBox esdsBox1 = (ESDescriptorBox)cur1;
                ESDescriptorBox esdsBox2 = (ESDescriptorBox)cur2;
                ESDescriptor esd = this.mergeDescriptors(esdsBox1.getEsDescriptor(), esdsBox2.getEsDescriptor());
                esdsBox1.setDescriptor(esd);
                ase.addBox(cur1);
            }
        }
        return ase;
    }

    private ESDescriptor mergeDescriptors(BaseDescriptor des1, BaseDescriptor des2) {
        if (des1 instanceof ESDescriptor && des2 instanceof ESDescriptor) {
            ESDescriptor esds1 = (ESDescriptor)des1;
            ESDescriptor esds2 = (ESDescriptor)des2;
            if (esds1.getURLFlag() != esds2.getURLFlag()) {
                return null;
            }
            esds1.getURLLength();
            esds2.getURLLength();
            if (esds1.getDependsOnEsId() != esds2.getDependsOnEsId()) {
                return null;
            }
            if (esds1.getEsId() != esds2.getEsId()) {
                return null;
            }
            if (esds1.getoCREsId() != esds2.getoCREsId()) {
                return null;
            }
            if (esds1.getoCRstreamFlag() != esds2.getoCRstreamFlag()) {
                return null;
            }
            if (esds1.getRemoteODFlag() != esds2.getRemoteODFlag()) {
                return null;
            }
            if (esds1.getStreamDependenceFlag() != esds2.getStreamDependenceFlag()) {
                return null;
            }
            esds1.getStreamPriority();
            esds2.getStreamPriority();
            if (esds1.getURLString() != null) {
                esds1.getURLString().equals(esds2.getURLString());
            } else {
                esds2.getURLString();
            }
            if (esds1.getDecoderConfigDescriptor() != null ? !esds1.getDecoderConfigDescriptor().equals(esds2.getDecoderConfigDescriptor()) : esds2.getDecoderConfigDescriptor() != null) {
                DecoderConfigDescriptor dcd1 = esds1.getDecoderConfigDescriptor();
                DecoderConfigDescriptor dcd2 = esds2.getDecoderConfigDescriptor();
                if (dcd1.getAudioSpecificInfo() != null && dcd2.getAudioSpecificInfo() != null && !dcd1.getAudioSpecificInfo().equals(dcd2.getAudioSpecificInfo())) {
                    return null;
                }
                if (dcd1.getAvgBitRate() != dcd2.getAvgBitRate()) {
                    dcd1.setAvgBitRate((dcd1.getAvgBitRate() + dcd2.getAvgBitRate()) / 2L);
                }
                dcd1.getBufferSizeDB();
                dcd2.getBufferSizeDB();
                if (dcd1.getDecoderSpecificInfo() != null ? !dcd1.getDecoderSpecificInfo().equals(dcd2.getDecoderSpecificInfo()) : dcd2.getDecoderSpecificInfo() != null) {
                    return null;
                }
                if (dcd1.getMaxBitRate() != dcd2.getMaxBitRate()) {
                    dcd1.setMaxBitRate(Math.max(dcd1.getMaxBitRate(), dcd2.getMaxBitRate()));
                }
                if (!dcd1.getProfileLevelIndicationDescriptors().equals(dcd2.getProfileLevelIndicationDescriptors())) {
                    return null;
                }
                if (dcd1.getObjectTypeIndication() != dcd2.getObjectTypeIndication()) {
                    return null;
                }
                if (dcd1.getStreamType() != dcd2.getStreamType()) {
                    return null;
                }
                if (dcd1.getUpStream() != dcd2.getUpStream()) {
                    return null;
                }
            }
            if (esds1.getOtherDescriptors() != null ? !esds1.getOtherDescriptors().equals(esds2.getOtherDescriptors()) : esds2.getOtherDescriptors() != null) {
                return null;
            }
            if (esds1.getSlConfigDescriptor() != null ? !esds1.getSlConfigDescriptor().equals(esds2.getSlConfigDescriptor()) : esds2.getSlConfigDescriptor() != null) {
                return null;
            }
            return esds1;
        }
        LOG.logError("I can only merge ESDescriptors");
        return null;
    }

    @Override
    public List<Sample> getSamples() {
        ArrayList<Sample> lists = new ArrayList<Sample>();
        Track[] trackArray = this.tracks;
        int n = this.tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            lists.addAll(track.getSamples());
            ++n2;
        }
        return lists;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public synchronized long[] getSampleDurations() {
        int numSamples = 0;
        Track[] trackArray = this.tracks;
        int n = this.tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            numSamples += track.getSampleDurations().length;
            ++n2;
        }
        long[] decodingTimes = new long[numSamples];
        int index = 0;
        Track[] trackArray2 = this.tracks;
        int n3 = this.tracks.length;
        int n4 = 0;
        while (n4 < n3) {
            Track track = trackArray2[n4];
            long[] lArray = track.getSampleDurations();
            int n5 = lArray.length;
            int n6 = 0;
            while (n6 < n5) {
                long l = lArray[n6];
                decodingTimes[index++] = l;
                ++n6;
            }
            ++n4;
        }
        return decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
                ++n2;
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                int[] list;
                int[] nArray = list = (int[])iterator.next();
                int n3 = list.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompositionTimeToSample.Entry e;
                    int compositionTime = nArray[n4];
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1, compositionTime);
                        compositionTimeEntries.add(e);
                    } else {
                        e = compositionTimeEntries.getLast();
                        e.setCount(e.getCount() + 1);
                    }
                    ++n4;
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                numSyncSamples += track.getSyncSamples().length;
                ++n2;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            long samplesBefore = 0L;
            Track[] trackArray2 = this.tracks;
            int n3 = this.tracks.length;
            int n4 = 0;
            while (n4 < n3) {
                Track track = trackArray2[n4];
                long[] lArray = track.getSyncSamples();
                int n5 = lArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    long l = lArray[n6];
                    returnSyncSamples[pos++] = samplesBefore + l;
                    ++n6;
                }
                samplesBefore += (long)track.getSamples().size();
                ++n4;
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                list.addAll(track.getSampleDependencies());
                ++n2;
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }
}

