/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.EditBox;
import com.coremedia.iso.boxes.EditListBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.HintMediaHeaderBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.NullMediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SubtitleMediaHeaderBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.Edit;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.Fragmenter;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.TimeBasedFragmenter;
import com.googlecode.mp4parser.authoring.tracks.CencEncryptedTrack;
import com.googlecode.mp4parser.boxes.dece.SampleEncryptionBox;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.SampleGroupDescriptionBox;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.SampleToGroupBox;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Logger;
import com.googlecode.mp4parser.util.Math;
import com.googlecode.mp4parser.util.Mp4Arrays;
import com.googlecode.mp4parser.util.Path;
import com.mp4parser.iso14496.part12.SampleAuxiliaryInformationOffsetsBox;
import com.mp4parser.iso14496.part12.SampleAuxiliaryInformationSizesBox;
import com.mp4parser.iso23001.part7.CencSampleAuxiliaryDataFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4Builder
implements Mp4Builder {
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class);
    Map<Track, StaticChunkOffsetBox> chunkOffsetBoxes = new HashMap<Track, StaticChunkOffsetBox>();
    Set<SampleAuxiliaryInformationOffsetsBox> sampleAuxiliaryInformationOffsetsBoxes = new HashSet<SampleAuxiliaryInformationOffsetsBox>();
    HashMap<Track, List<Sample>> track2Sample = new HashMap();
    HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private Fragmenter fragmenter;

    private static long sum(int[] ls) {
        long rc = 0L;
        int[] nArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            long l = nArray[n2];
            rc += l;
            ++n2;
        }
        return rc;
    }

    private static long sum(long[] ls) {
        long rc = 0L;
        long[] lArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            rc += l;
            ++n2;
        }
        return rc;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return DefaultMp4Builder.gcd(b, a % b);
    }

    public void setFragmenter(Fragmenter fragmenter) {
        this.fragmenter = fragmenter;
    }

    @Override
    public Container build(Movie movie) {
        Object sizes;
        if (this.fragmenter == null) {
            this.fragmenter = new TimeBasedFragmenter(2.0);
        }
        LOG.logDebug("Creating movie " + movie);
        for (Track track : movie.getTracks()) {
            List<Sample> samples = track.getSamples();
            this.putSamples(track, samples);
            sizes = new long[samples.size()];
            int i = 0;
            while (i < ((Object)sizes).length) {
                Sample b = samples.get(i);
                sizes[i] = b.getSize();
                ++i;
            }
            this.track2SampleSizes.put(track, (long[])sizes);
        }
        BasicContainer isoFile = new BasicContainer();
        isoFile.addBox(this.createFileTypeBox(movie));
        HashMap<Track, int[]> chunks = new HashMap<Track, int[]>();
        sizes = movie.getTracks().iterator();
        while (sizes.hasNext()) {
            Track track = (Track)sizes.next();
            chunks.put(track, this.getChunkSizes(track));
        }
        MovieBox moov = this.createMovieBox(movie, chunks);
        isoFile.addBox(moov);
        List<SampleSizeBox> stszs = Path.getPaths(moov, "trak/mdia/minf/stbl/stsz");
        long contentSize = 0L;
        for (SampleSizeBox stsz : stszs) {
            contentSize += DefaultMp4Builder.sum(stsz.getSampleSizes());
        }
        LOG.logDebug("About to create mdat");
        InterleaveChunkMdat mdat = new InterleaveChunkMdat(movie, chunks, contentSize);
        isoFile.addBox(mdat);
        LOG.logDebug("mdat crated");
        long dataOffset = mdat.getDataOffset();
        for (StaticChunkOffsetBox chunkOffsetBox : this.chunkOffsetBoxes.values()) {
            long[] offsets = chunkOffsetBox.getChunkOffsets();
            int i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + dataOffset;
            }
        }
        for (SampleAuxiliaryInformationOffsetsBox saio : this.sampleAuxiliaryInformationOffsetsBoxes) {
            long offset = saio.getSize();
            offset += 44L;
            Object b = saio;
            block7: do {
                SampleAuxiliaryInformationOffsetsBox current = b;
                b = ((Box)b).getParent();
                for (Box box : ((Container)b).getBoxes()) {
                    if (box == current) continue block7;
                    offset += box.getSize();
                }
            } while (b instanceof Box);
            long[] saioOffsets = saio.getOffsets();
            int i = 0;
            while (i < saioOffsets.length) {
                saioOffsets[i] = saioOffsets[i] + offset;
                ++i;
            }
            saio.setOffsets(saioOffsets);
        }
        return isoFile;
    }

    protected List<Sample> putSamples(Track track, List<Sample> samples) {
        return this.track2Sample.put(track, samples);
    }

    protected FileTypeBox createFileTypeBox(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("mp42");
        minorBrands.add("iso6");
        minorBrands.add("avc1");
        minorBrands.add("isom");
        return new FileTypeBox("iso6", 1L, minorBrands);
    }

    protected MovieBox createMovieBox(Movie movie, Map<Track, int[]> chunks) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        mvhd.setMatrix(movie.getMatrix());
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration;
            if (track.getEdits() == null || track.getEdits().isEmpty()) {
                tracksDuration = track.getDuration() * movieTimeScale / track.getTrackMetaData().getTimescale();
            } else {
                double d = 0.0;
                for (Edit edit : track.getEdits()) {
                    d += (double)((long)edit.getSegmentDuration());
                }
                tracksDuration = (long)(d * (double)movieTimeScale);
            }
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            long l = nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        movieBox.addBox(mvhd);
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrackBox(track, movie, chunks));
        }
        Box udta = this.createUdta(movie);
        if (udta != null) {
            movieBox.addBox(udta);
        }
        return movieBox;
    }

    protected Box createUdta(Movie movie) {
        return null;
    }

    protected TrackBox createTrackBox(Track track, Movie movie, Map<Track, int[]> chunks) {
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setEnabled(true);
        tkhd.setInMovie(true);
        tkhd.setMatrix(track.getTrackMetaData().getMatrix());
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        if (track.getEdits() == null || track.getEdits().isEmpty()) {
            tkhd.setDuration(track.getDuration() * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        } else {
            long d = 0L;
            for (Edit edit : track.getEdits()) {
                d += (long)edit.getSegmentDuration();
            }
            tkhd.setDuration(d * track.getTrackMetaData().getTimescale());
        }
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        trackBox.addBox(tkhd);
        trackBox.addBox(this.createEdts(track, movie));
        MediaBox mdia = new MediaBox();
        trackBox.addBox(mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        mdhd.setDuration(track.getDuration());
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        mdia.addBox(mdhd);
        HandlerBox hdlr = new HandlerBox();
        mdia.addBox(hdlr);
        hdlr.setHandlerType(track.getHandler());
        MediaInformationBox minf = new MediaInformationBox();
        if (track.getHandler().equals("vide")) {
            minf.addBox(new VideoMediaHeaderBox());
        } else if (track.getHandler().equals("soun")) {
            minf.addBox(new SoundMediaHeaderBox());
        } else if (track.getHandler().equals("text")) {
            minf.addBox(new NullMediaHeaderBox());
        } else if (track.getHandler().equals("subt")) {
            minf.addBox(new SubtitleMediaHeaderBox());
        } else if (track.getHandler().equals("hint")) {
            minf.addBox(new HintMediaHeaderBox());
        } else if (track.getHandler().equals("sbtl")) {
            minf.addBox(new NullMediaHeaderBox());
        }
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        minf.addBox(dinf);
        Box stbl = this.createStbl(track, movie, chunks);
        minf.addBox(stbl);
        mdia.addBox(minf);
        LOG.logDebug("done with trak for track_" + track.getTrackMetaData().getTrackId());
        return trackBox;
    }

    protected Box createEdts(Track track, Movie movie) {
        if (track.getEdits() != null && track.getEdits().size() > 0) {
            EditListBox elst = new EditListBox();
            elst.setVersion(0);
            ArrayList<EditListBox.Entry> entries = new ArrayList<EditListBox.Entry>();
            for (Edit edit : track.getEdits()) {
                entries.add(new EditListBox.Entry(elst, java.lang.Math.round(edit.getSegmentDuration() * (double)movie.getTimescale()), edit.getMediaTime() * track.getTrackMetaData().getTimescale() / edit.getTimeScale(), edit.getMediaRate()));
            }
            elst.setEntries(entries);
            EditBox edts = new EditBox();
            edts.addBox(elst);
            return edts;
        }
        return null;
    }

    protected Box createStbl(Track track, Movie movie, Map<Track, int[]> chunks) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createCtts(track, stbl);
        this.createStss(track, stbl);
        this.createSdtp(track, stbl);
        this.createStsc(track, chunks, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, movie, chunks, stbl);
        HashMap<String, ArrayList<GroupEntry>> groupEntryFamilies = new HashMap<String, ArrayList<GroupEntry>>();
        for (Map.Entry<GroupEntry, long[]> entry : track.getSampleGroups().entrySet()) {
            String type = entry.getKey().getType();
            ArrayList<GroupEntry> groupEntries = (ArrayList<GroupEntry>)groupEntryFamilies.get(type);
            if (groupEntries == null) {
                groupEntries = new ArrayList<GroupEntry>();
                groupEntryFamilies.put(type, groupEntries);
            }
            groupEntries.add(entry.getKey());
        }
        for (Map.Entry<GroupEntry, Object> entry : groupEntryFamilies.entrySet()) {
            SampleGroupDescriptionBox sgdb = new SampleGroupDescriptionBox();
            String type = (String)((Object)entry.getKey());
            sgdb.setGroupingType(type);
            sgdb.setGroupEntries((List)entry.getValue());
            SampleToGroupBox sbgp = new SampleToGroupBox();
            sbgp.setGroupingType(type);
            SampleToGroupBox.Entry last = null;
            int i = 0;
            while (i < track.getSamples().size()) {
                int index = 0;
                int j = 0;
                while (j < ((List)entry.getValue()).size()) {
                    GroupEntry groupEntry = (GroupEntry)((List)entry.getValue()).get(j);
                    long[] sampleNums = track.getSampleGroups().get(groupEntry);
                    if (Arrays.binarySearch(sampleNums, (long)i) >= 0) {
                        index = j + 1;
                    }
                    ++j;
                }
                if (last == null || last.getGroupDescriptionIndex() != index) {
                    last = new SampleToGroupBox.Entry(1L, index);
                    sbgp.getEntries().add(last);
                } else {
                    last.setSampleCount(last.getSampleCount() + 1L);
                }
                ++i;
            }
            stbl.addBox(sgdb);
            stbl.addBox(sbgp);
        }
        if (track instanceof CencEncryptedTrack) {
            this.createCencBoxes((CencEncryptedTrack)track, stbl, chunks.get(track));
        }
        this.createSubs(track, stbl);
        LOG.logDebug("done with stbl for track_" + track.getTrackMetaData().getTrackId());
        return stbl;
    }

    protected void createSubs(Track track, SampleTableBox stbl) {
        if (track.getSubsampleInformationBox() != null) {
            stbl.addBox(track.getSubsampleInformationBox());
        }
    }

    protected void createCencBoxes(CencEncryptedTrack track, SampleTableBox stbl, int[] chunkSizes) {
        SampleAuxiliaryInformationSizesBox saiz = new SampleAuxiliaryInformationSizesBox();
        saiz.setAuxInfoType("cenc");
        saiz.setFlags(1);
        List<CencSampleAuxiliaryDataFormat> sampleEncryptionEntries = track.getSampleEncryptionEntries();
        if (track.hasSubSampleEncryption()) {
            short[] sizes = new short[sampleEncryptionEntries.size()];
            int i = 0;
            while (i < sizes.length) {
                sizes[i] = (short)sampleEncryptionEntries.get(i).getSize();
                ++i;
            }
            saiz.setSampleInfoSizes(sizes);
        } else {
            saiz.setDefaultSampleInfoSize(8);
            saiz.setSampleCount(track.getSamples().size());
        }
        SampleAuxiliaryInformationOffsetsBox saio = new SampleAuxiliaryInformationOffsetsBox();
        SampleEncryptionBox senc = new SampleEncryptionBox();
        senc.setSubSampleEncryption(track.hasSubSampleEncryption());
        senc.setEntries(sampleEncryptionEntries);
        long offset = senc.getOffsetToFirstIV();
        int index = 0;
        long[] offsets = new long[chunkSizes.length];
        int i = 0;
        while (i < chunkSizes.length) {
            offsets[i] = offset;
            int j = 0;
            while (j < chunkSizes[i]) {
                offset += (long)sampleEncryptionEntries.get(index++).getSize();
                ++j;
            }
            ++i;
        }
        saio.setOffsets(offsets);
        stbl.addBox(saiz);
        stbl.addBox(saio);
        stbl.addBox(senc);
        this.sampleAuxiliaryInformationOffsetsBoxes.add(saio);
    }

    protected void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox(track.getSampleDescriptionBox());
    }

    protected void createStco(Track targetTrack, Movie movie, Map<Track, int[]> chunks, SampleTableBox stbl) {
        if (this.chunkOffsetBoxes.get(targetTrack) == null) {
            long offset = 0L;
            LOG.logDebug("Calculating chunk offsets for track_" + targetTrack.getTrackMetaData().getTrackId());
            ArrayList<Track> tracks = new ArrayList<Track>(chunks.keySet());
            Collections.sort(tracks, new Comparator<Track>(){

                @Override
                public int compare(Track o1, Track o2) {
                    return CastUtils.l2i(o1.getTrackMetaData().getTrackId() - o2.getTrackMetaData().getTrackId());
                }
            });
            HashMap<Track, Integer> trackToChunk = new HashMap<Track, Integer>();
            HashMap<Track, Integer> trackToSample = new HashMap<Track, Integer>();
            HashMap<Track, Double> trackToTime = new HashMap<Track, Double>();
            for (Track track : tracks) {
                trackToChunk.put(track, 0);
                trackToSample.put(track, 0);
                trackToTime.put(track, 0.0);
                this.chunkOffsetBoxes.put(track, new StaticChunkOffsetBox());
            }
            while (true) {
                Track nextChunksTrack = null;
                for (Track track : tracks) {
                    if (nextChunksTrack != null && !((Double)trackToTime.get(track) < (Double)trackToTime.get(nextChunksTrack)) || (Integer)trackToChunk.get(track) >= chunks.get(track).length) continue;
                    nextChunksTrack = track;
                }
                if (nextChunksTrack == null) break;
                ChunkOffsetBox chunkOffsetBox = this.chunkOffsetBoxes.get(nextChunksTrack);
                chunkOffsetBox.setChunkOffsets(Mp4Arrays.copyOfAndAppend(chunkOffsetBox.getChunkOffsets(), offset));
                int nextChunksIndex = (Integer)trackToChunk.get(nextChunksTrack);
                int numberOfSampleInNextChunk = chunks.get(nextChunksTrack)[nextChunksIndex];
                int startSample = (Integer)trackToSample.get(nextChunksTrack);
                double time = (Double)trackToTime.get(nextChunksTrack);
                long[] durs = nextChunksTrack.getSampleDurations();
                int j = startSample;
                while (j < startSample + numberOfSampleInNextChunk) {
                    offset += this.track2SampleSizes.get(nextChunksTrack)[j];
                    time += (double)durs[j] / (double)nextChunksTrack.getTrackMetaData().getTimescale();
                    ++j;
                }
                trackToChunk.put(nextChunksTrack, nextChunksIndex + 1);
                trackToSample.put(nextChunksTrack, startSample + numberOfSampleInNextChunk);
                trackToTime.put(nextChunksTrack, time);
            }
        }
        stbl.addBox(this.chunkOffsetBoxes.get(targetTrack));
    }

    protected void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox(stsz);
    }

    protected void createStsc(Track track, Map<Track, int[]> chunks, SampleTableBox stbl) {
        int[] tracksChunkSizes = chunks.get(track);
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        long lastChunkSize = Integer.MIN_VALUE;
        int i = 0;
        while (i < tracksChunkSizes.length) {
            if (lastChunkSize != (long)tracksChunkSizes[i]) {
                stsc.getEntries().add(new SampleToChunkBox.Entry(i + 1, tracksChunkSizes[i], 1L));
                lastChunkSize = tracksChunkSizes[i];
            }
            ++i;
        }
        stbl.addBox(stsc);
    }

    protected void createSdtp(Track track, SampleTableBox stbl) {
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            SampleDependencyTypeBox sdtp = new SampleDependencyTypeBox();
            sdtp.setEntries(track.getSampleDependencies());
            stbl.addBox(sdtp);
        }
    }

    protected void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox(stss);
        }
    }

    protected void createCtts(Track track, SampleTableBox stbl) {
        List<CompositionTimeToSample.Entry> compositionTimeToSampleEntries = track.getCompositionTimeEntries();
        if (compositionTimeToSampleEntries != null && !compositionTimeToSampleEntries.isEmpty()) {
            CompositionTimeToSample ctts = new CompositionTimeToSample();
            ctts.setEntries(compositionTimeToSampleEntries);
            stbl.addBox(ctts);
        }
    }

    protected void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>();
        long[] lArray = track.getSampleDurations();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long delta = lArray[n2];
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
            } else {
                lastEntry = new TimeToSampleBox.Entry(1L, delta);
                entries.add(lastEntry);
            }
            ++n2;
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox(stts);
    }

    int[] getChunkSizes(Track track) {
        long[] referenceChunkStarts = this.fragmenter.sampleNumbers(track);
        int[] chunkSizes = new int[referenceChunkStarts.length];
        int i = 0;
        while (i < referenceChunkStarts.length) {
            long start = referenceChunkStarts[i] - 1L;
            long end = referenceChunkStarts.length == i + 1 ? (long)track.getSamples().size() : referenceChunkStarts[i + 1] - 1L;
            chunkSizes[i] = CastUtils.l2i(end - start);
            ++i;
        }
        assert ((long)this.track2Sample.get(track).size() == DefaultMp4Builder.sum(chunkSizes)) : "The number of samples and the sum of all chunk lengths must be equal";
        return chunkSizes;
    }

    public long getTimescale(Movie movie) {
        long timescale = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            timescale = Math.lcm(timescale, track.getTrackMetaData().getTimescale());
        }
        return timescale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterleaveChunkMdat
    implements Box {
        List<Track> tracks;
        List<List<Sample>> chunkList = new ArrayList<List<Sample>>();
        Container parent;
        long contentSize;

        private InterleaveChunkMdat(Movie movie, Map<Track, int[]> chunks, long contentSize) {
            this.contentSize = contentSize;
            this.tracks = movie.getTracks();
            ArrayList<Track> tracks = new ArrayList<Track>(chunks.keySet());
            Collections.sort(tracks, new Comparator<Track>(){

                @Override
                public int compare(Track o1, Track o2) {
                    return CastUtils.l2i(o1.getTrackMetaData().getTrackId() - o2.getTrackMetaData().getTrackId());
                }
            });
            HashMap<Track, Integer> trackToChunk = new HashMap<Track, Integer>();
            HashMap<Track, Integer> trackToSample = new HashMap<Track, Integer>();
            HashMap<Track, Double> trackToTime = new HashMap<Track, Double>();
            for (Track track : tracks) {
                trackToChunk.put(track, 0);
                trackToSample.put(track, 0);
                trackToTime.put(track, 0.0);
            }
            while (true) {
                Track nextChunksTrack = null;
                for (Track track : tracks) {
                    if (nextChunksTrack != null && !((Double)trackToTime.get(track) < (Double)trackToTime.get(nextChunksTrack)) || (Integer)trackToChunk.get(track) >= chunks.get(track).length) continue;
                    nextChunksTrack = track;
                }
                if (nextChunksTrack == null) break;
                int nextChunksIndex = (Integer)trackToChunk.get(nextChunksTrack);
                int numberOfSampleInNextChunk = chunks.get(nextChunksTrack)[nextChunksIndex];
                int startSample = (Integer)trackToSample.get(nextChunksTrack);
                double time = (Double)trackToTime.get(nextChunksTrack);
                int j = startSample;
                while (j < startSample + numberOfSampleInNextChunk) {
                    time += (double)nextChunksTrack.getSampleDurations()[j] / (double)nextChunksTrack.getTrackMetaData().getTimescale();
                    ++j;
                }
                this.chunkList.add(nextChunksTrack.getSamples().subList(startSample, startSample + numberOfSampleInNextChunk));
                trackToChunk.put(nextChunksTrack, nextChunksIndex + 1);
                trackToSample.put(nextChunksTrack, startSample + numberOfSampleInNextChunk);
                trackToTime.put(nextChunksTrack, time);
            }
        }

        @Override
        public Container getParent() {
            return this.parent;
        }

        @Override
        public void setParent(Container parent) {
            this.parent = parent;
        }

        @Override
        public long getOffset() {
            throw new RuntimeException("Doesn't have any meaning for programmatically created boxes");
        }

        @Override
        public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        }

        public long getDataOffset() {
            Object b = this;
            long offset = 16L;
            while (b instanceof Box) {
                for (Box box : ((Box)b).getParent().getBoxes()) {
                    if (b == box) break;
                    offset += box.getSize();
                }
                b = ((Box)b).getParent();
            }
            return offset;
        }

        @Override
        public String getType() {
            return "mdat";
        }

        @Override
        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + 8L < 0x100000000L;
        }

        @Override
        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(16);
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32(bb, size);
            } else {
                IsoTypeWriter.writeUInt32(bb, 1L);
            }
            bb.put(IsoFile.fourCCtoBytes("mdat"));
            if (this.isSmallBox(size)) {
                bb.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64(bb, size);
            }
            bb.rewind();
            writableByteChannel.write(bb);
            long writtenBytes = 0L;
            long writtenMegaBytes = 0L;
            LOG.logDebug("About to write " + this.contentSize);
            for (List<Sample> samples : this.chunkList) {
                for (Sample sample : samples) {
                    sample.writeTo(writableByteChannel);
                    if ((writtenBytes += sample.getSize()) <= 0x100000L) continue;
                    writtenBytes -= 0x100000L;
                    LOG.logDebug("Written " + ++writtenMegaBytes + "MB");
                }
            }
        }
    }
}

