/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.Fragmenter;
import com.googlecode.mp4parser.util.Mp4Arrays;
import java.util.Arrays;

public class TimeBasedFragmenter
implements Fragmenter {
    private int fragmentLength = 2;
    private Movie movie;

    public TimeBasedFragmenter(Movie movie, int fragmentLength) {
        this.movie = movie;
        this.fragmentLength = fragmentLength;
    }

    public long[] sampleNumbers(Track track) {
        long[] segmentStartSamples = new long[]{1L};
        long[] sampleDurations = track.getSampleDurations();
        long[] syncSamples = track.getSyncSamples();
        long timescale = track.getTrackMetaData().getTimescale();
        double time = 0.0;
        int i = 0;
        while (i < sampleDurations.length) {
            if ((time += (double)sampleDurations[i] / (double)timescale) >= (double)this.fragmentLength && (syncSamples == null || Arrays.binarySearch(syncSamples, (long)(i + 1)) >= 0)) {
                if (i > 0) {
                    segmentStartSamples = Mp4Arrays.copyOfAndAppend(segmentStartSamples, i + 1);
                }
                time = 0.0;
            }
            ++i;
        }
        return segmentStartSamples;
    }
}

