/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.EditListBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.SampleList;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Edit;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.SampleGroupDescriptionBox;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.SampleToGroupBox;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Mp4Arrays;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mp4TrackImpl
extends AbstractTrack {
    TrackBox trackBox;
    IsoFile[] fragments;
    private List<Sample> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private long[] decodingTimes;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples = null;
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private SubSampleInformationBox subSampleInformationBox = null;

    public Mp4TrackImpl(String name, TrackBox trackBox, IsoFile ... fragments) {
        super(name);
        this.trackBox = trackBox;
        long trackId = trackBox.getTrackHeaderBox().getTrackId();
        this.samples = new SampleList(trackBox, fragments);
        SampleTableBox stbl = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        ArrayList<TimeToSampleBox.Entry> decodingTimeEntries = new ArrayList<TimeToSampleBox.Entry>();
        this.compositionTimeEntries = new ArrayList<CompositionTimeToSample.Entry>();
        this.sampleDependencies = new ArrayList<SampleDependencyTypeBox.Entry>();
        decodingTimeEntries.addAll(stbl.getTimeToSampleBox().getEntries());
        if (stbl.getCompositionTimeToSample() != null) {
            this.compositionTimeEntries.addAll(stbl.getCompositionTimeToSample().getEntries());
        }
        if (stbl.getSampleDependencyTypeBox() != null) {
            this.sampleDependencies.addAll(stbl.getSampleDependencyTypeBox().getEntries());
        }
        if (stbl.getSyncSampleBox() != null) {
            this.syncSamples = stbl.getSyncSampleBox().getSampleNumber();
        }
        this.subSampleInformationBox = (SubSampleInformationBox)Path.getPath(stbl, "subs");
        ArrayList<MovieFragmentBox> movieFragmentBoxes = new ArrayList<MovieFragmentBox>();
        movieFragmentBoxes.addAll(((Box)((Object)trackBox.getParent())).getParent().getBoxes(MovieFragmentBox.class));
        IsoFile[] isoFileArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IsoFile fragment = isoFileArray[n2];
            movieFragmentBoxes.addAll(fragment.getBoxes(MovieFragmentBox.class));
            ++n2;
        }
        this.sampleDescriptionBox = stbl.getSampleDescriptionBox();
        int lastSubsSample = 0;
        List<MovieExtendsBox> movieExtendsBoxes = trackBox.getParent().getBoxes(MovieExtendsBox.class);
        if (movieExtendsBoxes.size() > 0) {
            for (MovieExtendsBox mvex : movieExtendsBoxes) {
                List<TrackExtendsBox> trackExtendsBoxes = mvex.getBoxes(TrackExtendsBox.class);
                for (TrackExtendsBox trackExtendsBox : trackExtendsBoxes) {
                    if (trackExtendsBox.getTrackId() != trackId) continue;
                    List subss = Path.getPaths(((Box)((Object)trackBox.getParent())).getParent(), "/moof/traf/subs");
                    if (subss.size() > 0) {
                        this.subSampleInformationBox = new SubSampleInformationBox();
                    }
                    long sampleNumber = 1L;
                    for (MovieFragmentBox movieFragmentBox : movieFragmentBoxes) {
                        List<TrackFragmentBox> trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                        for (TrackFragmentBox traf : trafs) {
                            if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                            SubSampleInformationBox subs = (SubSampleInformationBox)Path.getPath(traf, "subs");
                            if (subs != null) {
                                long difFromLastFragment = sampleNumber - (long)lastSubsSample - 1L;
                                for (SubSampleInformationBox.SubSampleEntry subSampleEntry : subs.getEntries()) {
                                    SubSampleInformationBox.SubSampleEntry se = new SubSampleInformationBox.SubSampleEntry();
                                    se.getSubsampleEntries().addAll(subSampleEntry.getSubsampleEntries());
                                    if (difFromLastFragment != 0L) {
                                        se.setSampleDelta(difFromLastFragment + subSampleEntry.getSampleDelta());
                                        difFromLastFragment = 0L;
                                    } else {
                                        se.setSampleDelta(subSampleEntry.getSampleDelta());
                                    }
                                    this.subSampleInformationBox.getEntries().add(se);
                                }
                            }
                            List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                            for (TrackRunBox trun : truns) {
                                TrackFragmentHeaderBox tfhd = ((TrackFragmentBox)trun.getParent()).getTrackFragmentHeaderBox();
                                boolean first = true;
                                for (TrackRunBox.Entry entry : trun.getEntries()) {
                                    SampleFlags sampleFlags;
                                    Object e;
                                    if (trun.isSampleDurationPresent()) {
                                        if (decodingTimeEntries.size() == 0 || ((TimeToSampleBox.Entry)decodingTimeEntries.get(decodingTimeEntries.size() - 1)).getDelta() != entry.getSampleDuration()) {
                                            decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                        } else {
                                            e = (TimeToSampleBox.Entry)decodingTimeEntries.get(decodingTimeEntries.size() - 1);
                                            ((TimeToSampleBox.Entry)e).setCount(((TimeToSampleBox.Entry)e).getCount() + 1L);
                                        }
                                    } else if (tfhd.hasDefaultSampleDuration()) {
                                        decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, tfhd.getDefaultSampleDuration()));
                                    } else {
                                        decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, trackExtendsBox.getDefaultSampleDuration()));
                                    }
                                    if (trun.isSampleCompositionTimeOffsetPresent()) {
                                        if (this.compositionTimeEntries.size() == 0 || (long)this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                            this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i(entry.getSampleCompositionTimeOffset())));
                                        } else {
                                            e = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                                            ((CompositionTimeToSample.Entry)e).setCount(((CompositionTimeToSample.Entry)e).getCount() + 1);
                                        }
                                    }
                                    if ((sampleFlags = trun.isSampleFlagsPresent() ? entry.getSampleFlags() : (first && trun.isFirstSampleFlagsPresent() ? trun.getFirstSampleFlags() : (tfhd.hasDefaultSampleFlags() ? tfhd.getDefaultSampleFlags() : trackExtendsBox.getDefaultSampleFlags()))) != null && !sampleFlags.isSampleIsDifferenceSample()) {
                                        this.syncSamples = Mp4Arrays.copyOfAndAppend(this.syncSamples, sampleNumber);
                                    }
                                    ++sampleNumber;
                                    first = false;
                                }
                            }
                        }
                    }
                }
            }
            new ArrayList();
            new ArrayList();
            for (MovieFragmentBox movieFragmentBox : movieFragmentBoxes) {
                for (TrackFragmentBox traf : movieFragmentBox.getBoxes(TrackFragmentBox.class)) {
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                    this.sampleGroups = this.getSampleGroups(Path.getPaths(traf, "sgpd"), Path.getPaths(traf, "sbgp"), this.sampleGroups);
                }
            }
        } else {
            this.sampleGroups = this.getSampleGroups(stbl.getBoxes(SampleGroupDescriptionBox.class), stbl.getBoxes(SampleToGroupBox.class), this.sampleGroups);
        }
        this.decodingTimes = TimeToSampleBox.blowupTimeToSamples(decodingTimeEntries);
        MediaHeaderBox mdhd = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox tkhd = trackBox.getTrackHeaderBox();
        this.trackMetaData.setTrackId(tkhd.getTrackId());
        this.trackMetaData.setCreationTime(mdhd.getCreationTime());
        this.trackMetaData.setLanguage(mdhd.getLanguage());
        this.trackMetaData.setModificationTime(mdhd.getModificationTime());
        this.trackMetaData.setTimescale(mdhd.getTimescale());
        this.trackMetaData.setHeight(tkhd.getHeight());
        this.trackMetaData.setWidth(tkhd.getWidth());
        this.trackMetaData.setLayer(tkhd.getLayer());
        this.trackMetaData.setMatrix(tkhd.getMatrix());
        this.trackMetaData.setVolume(tkhd.getVolume());
        EditListBox elst = (EditListBox)Path.getPath(trackBox, "edts/elst");
        MovieHeaderBox movieHeaderBox = (MovieHeaderBox)Path.getPath(trackBox, "../mvhd");
        if (elst != null) {
            for (EditListBox.Entry e : elst.getEntries()) {
                this.edits.add(new Edit(e.getMediaTime(), mdhd.getTimescale(), e.getMediaRate(), (double)e.getSegmentDuration() / (double)movieHeaderBox.getTimescale()));
            }
        }
    }

    private Map<GroupEntry, long[]> getSampleGroups(List<SampleGroupDescriptionBox> sgdbs, List<SampleToGroupBox> sbgps, Map<GroupEntry, long[]> sampleGroups) {
        for (SampleGroupDescriptionBox sgdb : sgdbs) {
            boolean found = false;
            for (SampleToGroupBox sbgp : sbgps) {
                if (!sbgp.getGroupingType().equals(sgdb.getGroupEntries().get(0).getType())) continue;
                found = true;
                int sampleNum = 0;
                for (SampleToGroupBox.Entry entry : sbgp.getEntries()) {
                    if (entry.getGroupDescriptionIndex() > 0) {
                        GroupEntry groupEntry = sgdb.getGroupEntries().get(entry.getGroupDescriptionIndex() - 1);
                        long[] samples = sampleGroups.get(groupEntry);
                        if (samples == null) {
                            samples = new long[]{};
                        }
                        long[] nuSamples = new long[CastUtils.l2i(entry.getSampleCount()) + samples.length];
                        System.arraycopy(samples, 0, nuSamples, 0, samples.length);
                        int i = 0;
                        while ((long)i < entry.getSampleCount()) {
                            nuSamples[samples.length + i] = sampleNum + i;
                            ++i;
                        }
                        sampleGroups.put(groupEntry, nuSamples);
                    }
                    sampleNum = (int)((long)sampleNum + entry.getSampleCount());
                }
            }
            if (found) continue;
            throw new RuntimeException("Could not find SampleToGroupBox for " + sgdb.getGroupEntries().get(0).getType() + ".");
        }
        return sampleGroups;
    }

    @Override
    public void close() throws IOException {
        Container c = this.trackBox.getParent();
        if (c instanceof BasicContainer) {
            ((BasicContainer)c).close();
        }
        if (this.fragments != null) {
            IsoFile[] isoFileArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IsoFile fragment = isoFileArray[n2];
                fragment.close();
                ++n2;
            }
        }
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public synchronized long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.syncSamples == null || this.syncSamples.length == this.samples.size()) {
            return null;
        }
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.subSampleInformationBox;
    }
}

