/*
 * Copyright 2008 Whohoo Licensed under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */

package com.googlecode.mycontainer.kernel.reflect.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

import com.googlecode.mycontainer.kernel.interceptors.ProxyInterceptor;


public class ProxyChainImpl implements ProxyChain, Serializable {

	private static final long serialVersionUID = -4163309943092048585L;

	private final Iterator<ProxyInterceptor> interceptors;

	public ProxyChainImpl(Iterator<ProxyInterceptor> interceptors) {
		this.interceptors = interceptors;
	}

	public Object proceed(Request request) throws Throwable {
		if (interceptors.hasNext()) {
			ProxyInterceptor interceptor = interceptors.next();
			Object ret = interceptor.intercept(request, this);
			return ret;
		}
		Object impl = request.getImpl();
		Object[] args = request.getValues();
		Method method = request.getMethod();
		String name = method.getName();
		Class<?>[] parameterTypes = method.getParameterTypes();
		Method implMethod = impl.getClass().getMethod(name, parameterTypes);
		try {
			implMethod.setAccessible(true);
			Object ret = implMethod.invoke(impl, args);
			return ret;
		} catch (InvocationTargetException e) {
			Throwable targetException = e.getTargetException();
			throw targetException;
		}
	}

}
