/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.ShutdownHook;
import com.googlecode.mycontainer.kernel.naming.MyContainerContext;
import com.googlecode.mycontainer.kernel.naming.MyContainerContextFactory;
import com.googlecode.mycontainer.kernel.naming.ThreadLocalObjectProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kernel
implements Serializable {
    private static final long serialVersionUID = -9088221853026134701L;
    private static final Logger LOG = LoggerFactory.getLogger(Kernel.class);
    private MyContainerContext context;
    private Map<Object, Object> env;
    private final String name;
    private final List<ShutdownHook> hooks = new ArrayList<ShutdownHook>();
    private final Object mutex = new Object();

    public Kernel(String name) {
        this.name = name;
    }

    public void boot(Map<String, Object> env) {
        try {
            LOG.info("Booting up Container " + this.name);
            LOG.debug("Booting up Container on " + this.getClass().getClassLoader());
            this.env = new Hashtable<String, Object>(env);
            LOG.debug("Booting up JNDI");
            this.context = new MyContainerContext(env);
            this.context.bind("Kernel", (Object)this);
            this.context.bind("tl", (Object)new ThreadLocalObjectProvider());
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOG.info("Shutting down contaier " + this.name);
        while (!this.hooks.isEmpty()) {
            ShutdownHook hook = this.hooks.remove(this.hooks.size() - 1);
            hook.shutdown();
        }
        MyContainerContextFactory.removeContainer(this.name);
        LOG.info("Done");
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public MyContainerContext getContext() {
        return this.context;
    }

    public void setContext(MyContainerContext context) {
        this.context = context;
    }

    public Map<Object, Object> getEnv() {
        return this.env;
    }

    public void addShutdownHook(ShutdownHook hook) {
        this.hooks.add(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        try {
            LOG.info("Waiting for kernel shutdown");
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.wait();
            }
        }
        catch (InterruptedException e) {
            throw new KernelRuntimeException(e);
        }
    }
}

