/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.boot;

import com.googlecode.mycontainer.kernel.Kernel;
import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import com.googlecode.mycontainer.kernel.deploy.MyTransactionManagerDeployer;
import com.googlecode.mycontainer.kernel.deploy.VMShutdownHookDeployer;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerBuilder {
    private final InitialContext ctx;

    public ContainerBuilder() throws NamingException {
        this(new InitialContext());
    }

    public ContainerBuilder(Properties props) throws NamingException {
        this(new InitialContext(props));
    }

    public ContainerBuilder(InitialContext ctx) {
        this.ctx = ctx;
    }

    public void deployJTA() {
        MyTransactionManagerDeployer jta = this.createDeployer(MyTransactionManagerDeployer.class);
        jta.setName("TransactionManager");
        jta.deploy();
    }

    public void deployVMShutdownHook() {
        VMShutdownHookDeployer deployer = this.createDeployer(VMShutdownHookDeployer.class);
        deployer.deploy();
    }

    public <T extends Deployer> T createDeployer(String deployer) {
        try {
            Class<?> clazz = Class.forName(deployer);
            return (T)this.createDeployer(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public <T extends Deployer> T createDeployer(Class<T> deployer) {
        try {
            Deployer ret = (Deployer)deployer.newInstance();
            ret.setContext(this.ctx);
            return (T)ret;
        }
        catch (InstantiationException e) {
            throw new KernelRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public InitialContext getContext() {
        return this.ctx;
    }

    public void waitFor() {
        try {
            Kernel kernel = (Kernel)this.ctx.lookup("Kernel");
            kernel.waitFor();
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }
}

