/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.deploy;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.interceptors.AbstractIntercetorDeployer;
import com.googlecode.mycontainer.kernel.reflect.proxy.ContextInterceptor;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntercetorDeployer
extends AbstractIntercetorDeployer {
    private static final long serialVersionUID = -6799619112352155878L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIntercetorDeployer.class);
    private String name;
    private final List<Class<ContextInterceptor>> interceptors = new ArrayList<Class<ContextInterceptor>>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public <T extends ContextInterceptor> void addContextInterceptor(Class<T> interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public <T extends ContextInterceptor> void removeContextInterceptor(Class<T> interceptor) {
        this.interceptors.remove(interceptor);
    }

    public List<ContextInterceptor> createInterceptors() {
        try {
            Context ctx = this.getContext();
            ArrayList<ContextInterceptor> ret = new ArrayList<ContextInterceptor>();
            for (Class<ContextInterceptor> clazz : this.interceptors) {
                ContextInterceptor interceptor = clazz.newInstance();
                interceptor.setContext(ctx);
                ret.add(interceptor);
            }
            return ret;
        }
        catch (InstantiationException e) {
            throw new KernelRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new KernelRuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            Context ctx = this.getContext();
            LOG.info("Undeploying: " + this.name);
            ctx.unbind(this.name);
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public void deploy() {
        try {
            Context ctx = this.getContext();
            LOG.info("Deploying: " + this.name);
            ctx.bind(this.name, (Object)this);
            this.getKernel().addShutdownHook(this);
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }
}

