/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.deploy;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.deploy.DeployException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import com.googlecode.mycontainer.kernel.deploy.NamingAliasDeployer;
import com.googlecode.mycontainer.kernel.jta.MyTransactionManager;
import com.googlecode.mycontainer.kernel.jta.MyUserTransaction;
import com.googlecode.mycontainer.kernel.naming.MyNameParser;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTransactionManagerDeployer
extends Deployer {
    private static final Logger LOG = LoggerFactory.getLogger(MyTransactionManagerDeployer.class);
    private static final long serialVersionUID = -8984147706790393546L;
    private String name;
    private String userTransactionName = MyNameParser.parseClassName("resource", UserTransaction.class);

    public String getUserTransactionName() {
        return this.userTransactionName;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void deploy() {
        try {
            Context ctx = this.getContext();
            LOG.info("Deploying: " + this.name);
            TransactionManager tm = this.getTransactionManager();
            MyUserTransaction ut = new MyUserTransaction(tm);
            ctx.bind(this.name, (Object)tm);
            ctx.bind(this.userTransactionName, (Object)ut);
            this.getKernel().addShutdownHook(this);
            String alias = MyNameParser.parseClassName("resource", UserTransaction.class);
            if (!this.userTransactionName.equals(alias)) {
                new NamingAliasDeployer(ctx, alias, this.userTransactionName).deploy();
            }
        }
        catch (NamingException e) {
            throw new DeployException(e);
        }
    }

    public void shutdown() {
        try {
            Context ctx = this.getContext();
            LOG.info("Undeploying: " + this.userTransactionName);
            ctx.unbind(this.userTransactionName);
            LOG.info("Undeploying: " + this.name);
            ctx.unbind(this.name);
        }
        catch (NamingException e) {
            throw new DeployException(e);
        }
    }

    private TransactionManager getTransactionManager() {
        try {
            Context ctx = this.getContext();
            MyTransactionManager ret = new MyTransactionManager(ctx.getEnvironment());
            return ret;
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }
}

