/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.deploy;

import com.googlecode.mycontainer.kernel.ShutdownHook;
import com.googlecode.mycontainer.kernel.deploy.DeployException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import javax.naming.Context;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamingDeployer
extends Deployer
implements ShutdownHook {
    private static final Logger LOG = LoggerFactory.getLogger(NamingDeployer.class);
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void deploy() {
        try {
            Context ctx = this.getContext();
            LOG.info("Deploying: " + this.name);
            ctx.bind(this.name, this.getResource());
            this.getKernel().addShutdownHook(this);
        }
        catch (NamingException e) {
            throw new DeployException(e);
        }
    }

    protected abstract Object getResource();

    public void shutdown() {
        try {
            Context ctx = this.getContext();
            LOG.info("Undeploying: " + this.name);
            ctx.unbind(this.name);
        }
        catch (NamingException e) {
            throw new DeployException(e);
        }
    }
}

