/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.deploy;

import com.googlecode.mycontainer.cpscanner.ClasspathScanner;
import com.googlecode.mycontainer.cpscanner.ListScannerListener;
import com.googlecode.mycontainer.cpscanner.ScannerListener;
import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import com.googlecode.mycontainer.kernel.deploy.ScannableDeployer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerDeployer
extends Deployer {
    private static final long serialVersionUID = 3224579186395148293L;
    private final ClasspathScanner scanner;
    private final ListScannerListener listener;
    private final List<ScannableDeployer> deployers = new ArrayList<ScannableDeployer>();

    public ScannerDeployer() {
        this.scanner = new ClasspathScanner();
        this.listener = new ListScannerListener();
        this.scanner.addListener((ScannerListener)this.listener);
    }

    public void add(ScannableDeployer deployer) {
        deployer.setContext(this.getContext());
        this.deployers.add(deployer);
    }

    @Override
    public void shutdown() {
    }

    public void scan(String className) {
        try {
            this.scanner.scan(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public void scan(Class<?> clazz) {
        this.scanner.scan(clazz);
    }

    public void scan(URL url) {
        this.scanner.scan(url);
    }

    public void deploy() {
        for (ScannableDeployer deployer : this.deployers) {
            List classes = this.listener.getClasses();
            List resources = this.listener.getResources();
            deployer.deploy(classes, resources);
        }
    }
}

