/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.deploy;

import com.googlecode.mycontainer.kernel.Kernel;
import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import javax.naming.Context;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMShutdownHookDeployer
extends Deployer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(VMShutdownHookDeployer.class);
    private static final long serialVersionUID = -2754930748172142004L;
    private String kernelName = "Kernel";

    public void setKernelName(String kernelName) {
        this.kernelName = kernelName;
    }

    public void deploy() {
        LOG.info("Deploy Virtual Machine Mycontainer shutdown hook: " + this.kernelName);
        Thread thread = new Thread((Runnable)this, "MycontainerShutdownHookThread");
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public void run() {
        try {
            LOG.info("Executing Virtual Machine Mycontainer shutdown hook: " + this.kernelName);
            Context ctx = this.getContext();
            Kernel kernel = (Kernel)ctx.lookup(this.kernelName);
            kernel.shutdown();
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public void shutdown() {
    }
}

