/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.jta;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTransaction
implements Transaction,
Serializable {
    private static final long serialVersionUID = -5531513227138116991L;
    private Collection<XAResource> xas = new HashSet<XAResource>();
    private List<Synchronization> syncs = new ArrayList<Synchronization>();
    private int status = 0;

    private Collection<XAResource> getXas() {
        return this.xas;
    }

    private boolean addXa(XAResource xa) {
        return this.xas.add(xa);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException("tx is not active: " + this.status);
        }
        try {
            this.beforeCompletion();
            this.status = 8;
            for (XAResource xa : this.getXas()) {
                xa.commit(null, true);
            }
            this.status = 3;
        }
        catch (XAException e) {
            throw new KernelRuntimeException(e);
        }
        this.afterCompletion(this.status);
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("tx is not active and marked to rollback: " + this.status);
        }
        try {
            this.status = 9;
            for (XAResource xa : this.getXas()) {
                xa.rollback(null);
            }
            this.status = 4;
            this.afterCompletion(this.status);
        }
        catch (XAException e) {
            throw new KernelRuntimeException(e);
        }
    }

    private void beforeCompletion() {
        for (int i = 0; i < this.syncs.size(); ++i) {
            Synchronization sync = this.syncs.get(i);
            sync.beforeCompletion();
        }
    }

    private void afterCompletion(int status) {
        for (int i = 0; i < this.syncs.size(); ++i) {
            Synchronization sync = this.syncs.get(i);
            sync.afterCompletion(status);
        }
    }

    public boolean delistResource(XAResource xa, int flag) throws IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException(Integer.toString(this.status));
        }
        boolean ret = this.getXas().remove(xa);
        return ret;
    }

    public boolean enlistResource(XAResource xa) throws RollbackException, IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException(Integer.toString(this.status));
        }
        boolean ret = this.addXa(xa);
        return ret;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.syncs.contains(sync)) {
            throw new SystemException("Sync already registered");
        }
        this.syncs.add(sync);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException(Integer.toString(this.status));
        }
        this.status = 1;
    }
}

