/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.jta;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.jta.MyTransaction;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTransactionManager
implements TransactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(MyTransactionManager.class);
    private final Hashtable<Object, Object> env;

    public MyTransactionManager(Hashtable<?, ?> env) {
        this.env = env;
    }

    private void bindTransaction(Transaction tx) {
        try {
            InitialContext ic = new InitialContext(this.env);
            ic.bind("tl/tx", (Object)tx);
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    private void unbindTransaction() {
        try {
            InitialContext ic = new InitialContext(this.env);
            ic.unbind("tl/tx");
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    private Transaction lookupTransaction() {
        try {
            InitialContext ic = new InitialContext(this.env);
            Transaction ret = (Transaction)ic.lookup("tl/tx");
            return ret;
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            throw new NotSupportedException("nested transcation");
        }
        tx = new MyTransaction();
        this.bindTransaction(tx);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx == null) {
            throw new IllegalStateException("no tx");
        }
        if (this.getStatus() == 1) {
            LOG.warn("Transaction STATUS_MARKED_ROLLBACK... Rolling back...");
            this.rollback();
            return;
        }
        this.getTransaction().commit();
        this.unbindTransaction();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            this.getTransaction().rollback();
            this.unbindTransaction();
        }
    }

    public Transaction getTransaction() throws SystemException {
        return this.lookupTransaction();
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            this.unbindTransaction();
        }
        return tx;
    }

    public void resume(Transaction transcation) throws InvalidTransactionException, IllegalStateException, SystemException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            throw new IllegalStateException("this thread has a tx");
        }
        this.bindTransaction(transcation);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.setRollbackOnly();
        }
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }
}

