/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.naming;

import com.googlecode.mycontainer.kernel.naming.MyNameParser;
import com.googlecode.mycontainer.kernel.naming.MyNamingEnumeration;
import com.googlecode.mycontainer.kernel.naming.ObjectProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyContainerContext
implements Context,
Serializable {
    private static final long serialVersionUID = -8498064310465367403L;
    private static final Logger LOG = LoggerFactory.getLogger(MyContainerContext.class);
    private final Map<String, Object> elements = new TreeMap<String, Object>();
    private final Map<String, Object> envs;
    private final NameParser nameParser = new MyNameParser();

    public MyContainerContext(Map<String, Object> envs) {
        this.envs = envs;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        String key = name.get(0);
        if (name.size() == 1) {
            if (this.elements.containsKey(key)) {
                throw new NameAlreadyBoundException(key);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding: " + key);
            }
            this.elements.put(key, obj);
            return;
        }
        Object o = this.lookupInstance(key, name = name.getSuffix(1));
        if (o != null && !(o instanceof Context)) {
            throw new NameAlreadyBoundException(key);
        }
        Context ctx = (Context)o;
        if (ctx == null) {
            ctx = new MyContainerContext(this.envs);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding: " + key);
            }
            this.elements.put(key, ctx);
        }
        ctx.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        MyContainerContext ctx = new MyContainerContext(this.envs);
        this.bind(name, (Object)ctx);
        return ctx;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    private Context getContext(Name name) throws NamingException {
        if (name.size() == 1) {
            return this;
        }
        name = name.getPrefix(name.size() - 1);
        return (Context)this.lookup(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Context ctx = this.getContext(name);
        String key = name.get(name.size());
        ctx.unbind(key);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)this.envs;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
                Binding binding = new Binding(entry.getKey(), entry.getValue());
                bindings.add(binding);
            }
            return new MyNamingEnumeration<Binding>(bindings.iterator());
        }
        Object obj = this.lookup(name);
        if (!(obj instanceof Context)) {
            throw new NamingException("Name is not context: " + name);
        }
        Context context = (Context)obj;
        NamingEnumeration<Binding> listBindings = context.listBindings("");
        return listBindings;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Name suffix;
        String key = name.get(0);
        Object ret = this.lookupInstance(key, suffix = name.getSuffix(1));
        if (ret instanceof Context) {
            Context ctx = (Context)ret;
            if (!suffix.isEmpty()) {
                ret = ctx.lookup(suffix);
            }
        }
        if (ret == null) {
            throw new NameNotFoundException(name.toString());
        }
        return ret;
    }

    private Object lookupInstance(String key, Name suffix) throws NamingException {
        Object ret = this.elements.get(key);
        if (ret instanceof ObjectProvider) {
            ObjectProvider provider = (ObjectProvider)ret;
            ret = provider.provide(suffix);
        }
        return ret;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.unbind(name);
        this.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new NamingException("not supported operation");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object value = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, value);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        String key = name.get(0);
        if (name.size() == 1) {
            if (!this.elements.containsKey(key)) {
                throw new NameNotFoundException(key);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Unbinding: " + key);
            }
            this.elements.remove(key);
            return;
        }
        Context ctx = (Context)this.lookupInstance(key, name = name.getSuffix(1));
        if (ctx != null) {
            ctx.unbind(name);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }
}

