/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.naming;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingHelper {
    private final Context ctx;

    public NamingHelper(Context ctx) {
        this.ctx = ctx;
    }

    public NamingHelper(Hashtable<?, ?> env) {
        try {
            this.ctx = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public Long generateId(String name) {
        try {
            long id = 0L;
            try {
                id = (Long)this.ctx.lookup(name);
            }
            catch (NameNotFoundException e) {
                this.ctx.bind(name, (Object)0L);
            }
            this.ctx.rebind(name, (Object)(++id));
            return id;
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public Long bind(String prefix, Object obj) {
        try {
            Long id = this.generateId(prefix + "/namingHelperId");
            Context sub = (Context)this.ctx.lookup(prefix + "/namingHelper");
            sub.bind("id" + id, obj);
            return id;
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public Object lookup(String prefix, Long id) {
        try {
            Object ret = this.ctx.lookup(prefix + "/namingHelper/" + id);
            return ret;
        }
        catch (NamingException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public Context getCtx() {
        return this.ctx;
    }
}

