/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.reflect;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    private final Class<?> clazz;

    public ReflectUtil(Class<?> clazz) {
        this.clazz = clazz;
    }

    public List<Field> getFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        ArrayList<Field> ret = new ArrayList<Field>(Arrays.asList(fields));
        Class<?> superclass = this.clazz.getSuperclass();
        if (superclass != null) {
            ReflectUtil util = new ReflectUtil(superclass);
            ret.addAll(util.getFields());
        }
        return ret;
    }

    public <T extends Annotation> List<Field> getFields(Class<T> type) {
        Field[] fields;
        ArrayList<Field> ret = new ArrayList<Field>();
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            T annotation = field.getAnnotation(type);
            if (annotation == null) continue;
            ret.add(field);
        }
        Class<?> superclass = this.clazz.getSuperclass();
        if (superclass != null) {
            ReflectUtil util = new ReflectUtil(superclass);
            ret.addAll(util.getFields(type));
        }
        return ret;
    }

    public static void setField(Field field, Object obj, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new KernelRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public <T extends Annotation> List<Method> getMethods(Class<T> type) {
        Method[] methods;
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method field : methods = this.clazz.getDeclaredMethods()) {
            T annotation = field.getAnnotation(type);
            if (annotation == null) continue;
            ret.add(field);
        }
        Class<?> superclass = this.clazz.getSuperclass();
        if (superclass != null) {
            ReflectUtil util = new ReflectUtil(superclass);
            ret.addAll(util.getMethods(type));
        }
        return ret;
    }

    public List<Method> getMethods() {
        Method[] methods;
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method field : methods = this.clazz.getDeclaredMethods()) {
            ret.add(field);
        }
        Class<?> superclass = this.clazz.getSuperclass();
        if (superclass != null) {
            ReflectUtil util = new ReflectUtil(superclass);
            ret.addAll(util.getMethods());
        }
        return ret;
    }

    public static void invokeMethod(Method method, Object obj, Object ... args) {
        try {
            boolean flag = method.isAccessible();
            method.setAccessible(true);
            method.invoke(obj, args);
            method.setAccessible(flag);
        }
        catch (IllegalArgumentException e) {
            throw new KernelRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new KernelRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new KernelRuntimeException(e);
        }
    }

    public static String location(Class<?> clazz) {
        ProtectionDomain pd = clazz.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL ret = cs.getLocation();
        return ret.toString();
    }

    public static List<String> location(String name) {
        return ReflectUtil.location(ReflectUtil.class.getClassLoader(), name);
    }

    public static List<URL> locationURL(String name) {
        return ReflectUtil.locationURL(ReflectUtil.class.getClassLoader(), name);
    }

    private static List<URL> locationURL(ClassLoader cl, String name) {
        try {
            Enumeration<URL> resources = cl.getResources(name);
            if (resources == null) {
                return null;
            }
            ArrayList<URL> ret = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                ret.add(url);
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> location(ClassLoader cl, String name) {
        List<URL> urls = ReflectUtil.locationURL(cl, name);
        ArrayList<String> ret = new ArrayList<String>();
        for (URL url : urls) {
            ret.add(url == null ? null : url.toString());
        }
        return ret;
    }

    public static Object classForName(String listener) {
        if (listener == null) {
            return null;
        }
        try {
            return Class.forName(listener);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> listener) {
        if (listener == null) {
            return null;
        }
        try {
            return listener.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

