/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.reflect.proxy;

import com.googlecode.mycontainer.kernel.interceptors.ProxyInterceptor;
import com.googlecode.mycontainer.kernel.reflect.proxy.ProxyChain;
import com.googlecode.mycontainer.kernel.reflect.proxy.Request;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyChainImpl
implements ProxyChain,
Serializable {
    private static final long serialVersionUID = -4163309943092048585L;
    private final Iterator<ProxyInterceptor> interceptors;

    public ProxyChainImpl(Iterator<ProxyInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public Object proceed(Request request) throws Throwable {
        if (this.interceptors.hasNext()) {
            ProxyInterceptor interceptor = this.interceptors.next();
            Object ret = interceptor.intercept(request, this);
            return ret;
        }
        Object impl = request.getImpl();
        Object[] args = request.getValues();
        Method method = request.getMethod();
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Method implMethod = impl.getClass().getMethod(name, parameterTypes);
        try {
            implMethod.setAccessible(true);
            Object ret = implMethod.invoke(impl, args);
            return ret;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
    }
}

