/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.kernel.reflect.proxy;

import com.googlecode.mycontainer.kernel.interceptors.ProxyInterceptor;
import com.googlecode.mycontainer.kernel.reflect.proxy.ProxyChainImpl;
import com.googlecode.mycontainer.kernel.reflect.proxy.Request;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyEngine<T>
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5953476982797780990L;
    private final List<ProxyInterceptor> interceptors = new ArrayList<ProxyInterceptor>();
    private final Class<T> api;
    private final T impl;
    private T proxy;
    private Object info;
    private final List<Class<?>> interfaces = new ArrayList();

    public ProxyEngine(Class<T> api, T impl) {
        this(api, impl, null);
    }

    public ProxyEngine(Class<T> api, T impl, Object info) {
        this.api = api;
        this.impl = impl;
        this.info = info;
    }

    public void addInterceptor(ProxyInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public T getProxy() {
        return this.proxy;
    }

    public void setProxy(T proxy) {
        this.proxy = proxy;
    }

    public T create() {
        Class[] apis = new Class[this.interfaces.size() + 1];
        apis = this.interfaces.toArray(apis);
        apis[this.interfaces.size()] = this.api;
        this.proxy = Proxy.newProxyInstance(this.api.getClassLoader(), apis, (InvocationHandler)this);
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ProxyChainImpl chain = new ProxyChainImpl(this.interceptors.iterator());
        Request request = new Request();
        request.setApi(this.api);
        request.setImpl(this.impl);
        request.setMethod(method);
        request.setValues(args);
        request.setInfo(this.info);
        request.setProxy(proxy);
        Object ret = chain.proceed(request);
        return ret;
    }

    public T getImpl() {
        return this.impl;
    }

    public static <T> T getImpl(T proxy) {
        ProxyEngine engine = (ProxyEngine)Proxy.getInvocationHandler(proxy);
        return engine.getImpl();
    }

    public void addInterface(Class<?> clazz) {
        this.interfaces.add(clazz);
    }
}

