package com.googlecode.mycontainer.commons.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.googlecode.mycontainer.commons.rhino.DefaultRhinoBoxBuilder;
import com.googlecode.mycontainer.commons.rhino.RhinoBox;

public class JSEngineFilter implements Filter {

	public static final String PATH = JSEngineFilter.class.getName() + ".path";
	public static final String RELOAD = JSEngineFilter.class.getName()
			+ ".reload";

	public RhinoBox getBox() {
		return DefaultRhinoBoxBuilder.getBox();
	}

	public void init(FilterConfig config) throws ServletException {
		String path = config.getInitParameter("script");
		if (path == null) {
			path = "jsengine.rhino.js";
		}
		boolean reload = !"false".equals(config.getInitParameter("reload"));
		ServletContext ctx = config.getServletContext();
		ctx.setAttribute(PATH, path);
		ctx.setAttribute(RELOAD, reload);
		load(ctx);
	}

	private void load(ServletContext ctx) {
		RhinoBox box = getBox();
		String path = (String) ctx.getAttribute(PATH);
		box.enter();
		try {
			URL url = getClass().getResource(path);
			if (url == null) {
				url = ctx.getResource(path);
			}
			if (url == null) {
				throw new RuntimeException("path not found: " + path);
			}
			box.source(url);
		} catch (MalformedURLException e) {
			throw new RuntimeException(e);
		} finally {
			box.exit();
		}
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest) request;
		ServletContext ctx = req.getSession().getServletContext();
		Boolean reload = (Boolean) ctx.getAttribute(RELOAD);
		if (reload) {
			load(ctx);
		}
		RhinoBox box = getBox();
		box.enter();
		try {
			box.invoke(getClass(), "onRequest", request, response, chain);
		} finally {
			box.exit();
		}
	}

	public void destroy() {
	}

}
