/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Realm
implements Serializable {
    private static final long serialVersionUID = -1858492564401032084L;
    private final Map<String, UserRole> users = new HashMap<String, UserRole>();
    private final String name;

    public Realm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, UserRole> getUsers() {
        return this.users;
    }

    public void addUser(String user, String password) {
        this.users.put(user, new UserRole(user, password));
    }

    public void addRole(String user, String role) {
        this.users.get(user).getRoles().add(role);
    }

    public void config(String user, String password, String ... roles) {
        this.addUser(user, password);
        for (String role : roles) {
            this.addRole(user, role);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserRole
    implements Serializable {
        private static final long serialVersionUID = -8567344310671232832L;
        private final String user;
        private final String password;
        private final Set<String> roles = new HashSet<String>();

        public UserRole(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserRole other = (UserRole)obj;
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }
    }
}

