/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.web.jetty;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyRequestLogImpl
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger LOG = LoggerFactory.getLogger(JettyRequestLogImpl.class);

    public void log(Request request, Response response) {
        if (LOG.isInfoEnabled()) {
            String remoteAddr = request.getRemoteAddr();
            String method = request.getMethod();
            String protocol = request.getProtocol();
            StringBuffer url = request.getRequestURL();
            LOG.info("Request: " + protocol + " " + method + " " + remoteAddr + " " + url);
        }
    }
}

