/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.web.jetty;

import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.reflect.ReflectUtil;
import com.googlecode.mycontainer.web.ContextWebServer;
import com.googlecode.mycontainer.web.FilterDesc;
import com.googlecode.mycontainer.web.Realm;
import com.googlecode.mycontainer.web.ServletDesc;
import com.googlecode.mycontainer.web.WebServerDeployer;
import com.googlecode.mycontainer.web.jetty.JettyRequestLogImpl;
import com.googlecode.mycontainer.web.jetty.SslConnectorInfo;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerDeployer
extends WebServerDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerDeployer.class);
    private static final long serialVersionUID = 3380253274628567229L;
    private Server server = new Server();

    public JettyServerDeployer() {
        System.setProperty("com.sun.faces.InjectionProvider", "com.googlecode.mycontainer.jsfprovider.MyContainerInjectionProvider");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new JettyRequestLogImpl());
        requestLogHandler.setServer(this.server);
    }

    public Server getServer() {
        return this.server;
    }

    protected Object getResource() {
        return this.server;
    }

    public void shutdown() {
        LOG.info("Shutting down Jetty web server...");
        try {
            this.server.stop();
            this.server.join();
        }
        catch (Exception e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        super.shutdown();
    }

    public void bindPort(int port) {
        SelectChannelConnector connector = this.createConnector(port);
        this.server.addConnector((Connector)connector);
    }

    private SelectChannelConnector createConnector(int port) {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        connector.setMaxIdleTime(30000);
        return connector;
    }

    public void bindPort(int port, int confidentialPort) {
        SelectChannelConnector connector = this.createConnector(port);
        connector.setConfidentialPort(confidentialPort);
        this.server.addConnector((Connector)connector);
    }

    @Deprecated
    public void bindSSLPort(int port, String keystore, String password) {
        SslConnectorInfo info = new SslConnectorInfo(port, keystore);
        info.setKeyManagerPassword(password);
        info.setKeyStorePassword(password);
        this.bindSSLPort(info);
    }

    public void bindSSLPort(SslConnectorInfo info) {
        Connector connector = info.createConnector();
        this.server.addConnector(connector);
    }

    public void deploy() {
        try {
            this.deployWebContexts();
            this.server.start();
        }
        catch (Exception e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        super.deploy();
    }

    private void deployWebContexts() {
        List<ContextWebServer> webContexts = this.getWebContexts();
        Handler[] handlers = new Handler[webContexts.size()];
        int i = 0;
        for (ContextWebServer contextWebServer : webContexts) {
            WebAppContext handler;
            if (contextWebServer.getResources() != null) {
                handler = new WebAppContext(contextWebServer.getResources(), contextWebServer.getContext());
            } else {
                handler = new ServletContextHandler(null, contextWebServer.getContext(), 3);
                handler.addServlet(DefaultServlet.class, "/*");
            }
            handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$");
            List<Object> listeners = contextWebServer.getListeners();
            for (Object listener : listeners) {
                if (listener instanceof String) {
                    listener = ReflectUtil.classForName((String)((String)listener));
                }
                if (listener instanceof Class) {
                    listener = ReflectUtil.newInstance((Class)((Class)listener));
                }
                handler.addEventListener((EventListener)listener);
            }
            List<FilterDesc> filters = contextWebServer.getFilters();
            for (FilterDesc desc : filters) {
                Object filter = desc.getFilter();
                if (filter instanceof Filter) {
                    FilterHolder holder = new FilterHolder((Filter)filter);
                    handler.addFilter(holder, desc.getPath(), 31);
                    continue;
                }
                if (filter instanceof FilterHolder) {
                    handler.addFilter((FilterHolder)filter, desc.getPath(), 31);
                    continue;
                }
                if (filter instanceof Class) {
                    handler.addFilter((Class)filter, desc.getPath(), 31);
                    continue;
                }
                handler.addFilter((String)filter, desc.getPath(), 31);
            }
            List<ServletDesc> servlets = contextWebServer.getServlets();
            for (ServletDesc desc : servlets) {
                Object servlet = desc.getServlet();
                if (servlet instanceof HttpServlet) {
                    ServletHolder holder = new ServletHolder((Servlet)((HttpServlet)servlet));
                    handler.addServlet(holder, desc.getPath());
                    continue;
                }
                if (servlet instanceof ServletHolder) {
                    handler.addServlet((ServletHolder)servlet, desc.getPath());
                    continue;
                }
                if (servlet instanceof Class) {
                    handler.addServlet((Class)servlet, desc.getPath());
                    continue;
                }
                handler.addServlet((String)servlet, desc.getPath());
            }
            handlers[i++] = handler;
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers);
        this.server.setHandler((Handler)contexts);
    }

    public void addRealm(Realm realm) {
        HashLoginService loginService = new HashLoginService();
        loginService.setName(realm.getName());
        Collection<Realm.UserRole> users = realm.getUsers().values();
        for (Realm.UserRole user : users) {
            String[] roles = user.getRoles().toArray(new String[0]);
            Password password = new Password(user.getPassword());
            loginService.putUser(user.getUser(), (Credential)password, roles);
        }
        this.server.addBean((Object)loginService);
    }

    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        WebAppContext webapp1 = new WebAppContext();
        webapp1.setContextPath("/ctx1");
        webapp1.setResourceBase("target");
        WebAppContext webapp2 = new WebAppContext();
        webapp2.setContextPath("/ctx2");
        webapp2.setResourceBase("src");
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{webapp1, webapp2});
        server.setHandler((Handler)contexts);
        server.start();
        server.join();
    }
}

