/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.web.jetty;

import java.io.Serializable;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;

public class SslConnectorInfo
implements Serializable {
    private static final long serialVersionUID = -1104209736781892413L;
    private int port = 8443;
    private boolean wantClientAuth = false;
    private boolean needClientAuth = false;
    private String keyStore;
    private String keyStorePassword;
    private String keyManagerPassword;
    private String certAlias;
    private String trustStore;
    private String trustStorePassword;
    private int maxIdleTime = 30000;

    public SslConnectorInfo() {
    }

    public SslConnectorInfo(String keyStore) {
        this.keyStore = keyStore;
    }

    public SslConnectorInfo(int port, String keyStore) {
        this.port = port;
        this.keyStore = keyStore;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public Connector createConnector() {
        SslContextFactory sslContextFactory = new SslContextFactory(this.keyStore);
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        sslContextFactory.setKeyManagerPassword(this.keyManagerPassword);
        sslContextFactory.setCertAlias(this.certAlias);
        sslContextFactory.setNeedClientAuth(this.needClientAuth);
        sslContextFactory.setWantClientAuth(this.wantClientAuth);
        sslContextFactory.setTrustStore(this.trustStore);
        sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        SslSocketConnector connector = new SslSocketConnector((org.eclipse.jetty.util.ssl.SslContextFactory)sslContextFactory);
        connector.setPort(this.port);
        connector.setMaxIdleTime(this.maxIdleTime);
        return connector;
    }
}

