/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class BinaryPropertyListWriter {
    OutputStream out;
    long count;
    Map<NSObject, Integer> idMap = new HashMap<NSObject, Integer>();
    int idSizeInBytes;

    public static void write(File file, NSObject root) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BinaryPropertyListWriter.write(out, root);
        ((OutputStream)out).close();
    }

    public static void write(OutputStream out, NSObject root) throws IOException {
        BinaryPropertyListWriter w = new BinaryPropertyListWriter(out);
        w.write(root);
    }

    public static byte[] writeToArray(NSObject root) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BinaryPropertyListWriter.write(bout, root);
        return bout.toByteArray();
    }

    BinaryPropertyListWriter(OutputStream outStr) throws IOException {
        this.out = new BufferedOutputStream(outStr);
    }

    void write(NSObject root) throws IOException {
        this.write("bplist00".getBytes());
        root.assignIDs(this);
        this.idSizeInBytes = BinaryPropertyListWriter.computeIdSizeInBytes(this.idMap.size());
        long[] offsets = new long[this.idMap.size()];
        for (Map.Entry<NSObject, Integer> entry : this.idMap.entrySet()) {
            NSObject obj = entry.getKey();
            int id = entry.getValue();
            offsets[id] = this.count;
            if (obj == null) {
                this.write(0);
                continue;
            }
            obj.toBinary(this);
        }
        long offsetTableOffset = this.count;
        int offsetSizeInBytes = this.computeOffsetSizeInBytes(this.count);
        for (long offset : offsets) {
            this.writeBytes(offset, offsetSizeInBytes);
        }
        this.write(new byte[6]);
        this.write(offsetSizeInBytes);
        this.write(this.idSizeInBytes);
        this.writeLong(this.idMap.size());
        this.writeLong(this.idMap.get(root).intValue());
        this.writeLong(offsetTableOffset);
        this.out.flush();
    }

    void assignID(NSObject obj) {
        if (!this.idMap.containsKey(obj)) {
            this.idMap.put(obj, this.idMap.size());
        }
    }

    int getID(NSObject obj) {
        return this.idMap.get(obj);
    }

    private static int computeIdSizeInBytes(int numberOfIds) {
        if (numberOfIds < 256) {
            return 1;
        }
        if (numberOfIds < 65536) {
            return 2;
        }
        return 4;
    }

    private int computeOffsetSizeInBytes(long maxOffset) {
        if (maxOffset < 256L) {
            return 1;
        }
        if (maxOffset < 65536L) {
            return 2;
        }
        if (maxOffset < 0x100000000L) {
            return 4;
        }
        return 8;
    }

    void writeIntHeader(int kind, int value) throws IOException {
        assert (value >= 0);
        if (value < 15) {
            this.write((kind << 4) + value);
        } else if (value < 256) {
            this.write((kind << 4) + 15);
            this.write(16);
            this.writeBytes(value, 1);
        } else if (value < 65536) {
            this.write((kind << 4) + 15);
            this.write(17);
            this.writeBytes(value, 2);
        } else {
            this.write((kind << 4) + 15);
            this.write(18);
            this.writeBytes(value, 4);
        }
    }

    void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
        this.count += (long)bytes.length;
    }

    void writeBytes(long value, int bytes) throws IOException {
        for (int i = bytes - 1; i >= 0; --i) {
            this.write((int)(value >> 8 * i));
        }
    }

    void writeID(int id) throws IOException {
        this.writeBytes(id, this.idSizeInBytes);
    }

    void writeLong(long value) throws IOException {
        this.writeBytes(value, 8);
    }

    void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(value));
    }
}

