/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import com.dd.plist.UID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NSObject {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String INDENT = "\t";
    static final int ASCII_LINE_LENGTH = 80;

    abstract void toXML(StringBuilder var1, int var2);

    void assignIDs(BinaryPropertyListWriter out) {
        out.assignID(this);
    }

    abstract void toBinary(BinaryPropertyListWriter var1) throws IOException;

    public String toXMLPropertyList() {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append(NEWLINE);
        xml.append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
        xml.append(NEWLINE);
        xml.append("<plist version=\"1.0\">");
        xml.append(NEWLINE);
        this.toXML(xml, 0);
        xml.append(NEWLINE);
        xml.append("</plist>");
        return xml.toString();
    }

    protected abstract void toASCII(StringBuilder var1, int var2);

    protected abstract void toASCIIGnuStep(StringBuilder var1, int var2);

    void indent(StringBuilder xml, int level) {
        for (int i = 0; i < level; ++i) {
            xml.append(INDENT);
        }
    }

    public static NSNumber wrap(long value) {
        return new NSNumber(value);
    }

    public static NSNumber wrap(double value) {
        return new NSNumber(value);
    }

    public static NSNumber wrap(boolean value) {
        return new NSNumber(value);
    }

    public static NSData wrap(byte[] value) {
        return new NSData(value);
    }

    public static NSArray wrap(Object[] value) {
        NSArray arr = new NSArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            arr.setValue(i, NSObject.wrap(value[i]));
        }
        return arr;
    }

    public static NSDictionary wrap(Map<String, Object> value) {
        NSDictionary dict = new NSDictionary();
        for (String key : value.keySet()) {
            dict.put(key, NSObject.wrap(value.get(key)));
        }
        return dict;
    }

    public static NSSet wrap(Set<Object> value) {
        NSSet set = new NSSet();
        for (Object o : value.toArray()) {
            set.addObject(NSObject.wrap(o));
        }
        return set;
    }

    public static NSObject wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NSObject) {
            return (NSObject)o;
        }
        Class<?> c = o.getClass();
        if (Boolean.class.equals(c)) {
            return NSObject.wrap((Boolean)o);
        }
        if (Byte.class.equals(c)) {
            return NSObject.wrap(((Byte)o).byteValue());
        }
        if (Short.class.equals(c)) {
            return NSObject.wrap(((Short)o).shortValue());
        }
        if (Integer.class.equals(c)) {
            return NSObject.wrap(((Integer)o).intValue());
        }
        if (Long.class.isAssignableFrom(c)) {
            return NSObject.wrap((Long)o);
        }
        if (Float.class.equals(c)) {
            return NSObject.wrap(((Float)o).floatValue());
        }
        if (Double.class.isAssignableFrom(c)) {
            return NSObject.wrap((Double)o);
        }
        if (String.class.equals(c)) {
            return new NSString((String)o);
        }
        if (Date.class.equals(c)) {
            return new NSDate((Date)o);
        }
        if (c.isArray()) {
            Class<?> cc = c.getComponentType();
            if (cc.equals(Byte.TYPE)) {
                return NSObject.wrap((byte[])o);
            }
            if (cc.equals(Boolean.TYPE)) {
                boolean[] array = (boolean[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            if (Float.TYPE.equals(cc)) {
                float[] array = (float[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            if (Double.TYPE.equals(cc)) {
                double[] array = (double[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            if (Short.TYPE.equals(cc)) {
                short[] array = (short[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            if (Integer.TYPE.equals(cc)) {
                int[] array = (int[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            if (Long.TYPE.equals(cc)) {
                long[] array = (long[])o;
                NSArray nsa = new NSArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    nsa.setValue(i, NSObject.wrap(array[i]));
                }
                return nsa;
            }
            return NSObject.wrap((Object[])o);
        }
        if (Map.class.isAssignableFrom(c)) {
            Map map = (Map)o;
            Set keys = map.keySet();
            NSDictionary dict = new NSDictionary();
            for (Object key : keys) {
                Object val = map.get(key);
                dict.put(String.valueOf(key), NSObject.wrap(val));
            }
            return dict;
        }
        if (Collection.class.isAssignableFrom(c)) {
            Collection coll = (Collection)o;
            return NSObject.wrap(coll.toArray());
        }
        return NSObject.wrapSerialized(o);
    }

    public static NSData wrapSerialized(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            return new NSData(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException("The given object of class " + o.getClass().toString() + " could not be serialized and stored in a NSData object.");
        }
    }

    public Object toJavaObject() {
        if (this instanceof NSArray) {
            NSObject[] arrayA = ((NSArray)this).getArray();
            Object[] arrayB = new Object[arrayA.length];
            for (int i = 0; i < arrayA.length; ++i) {
                arrayB[i] = arrayA[i].toJavaObject();
            }
            return arrayB;
        }
        if (this instanceof NSDictionary) {
            HashMap<String, NSObject> hashMapA = ((NSDictionary)this).getHashMap();
            HashMap<String, Object> hashMapB = new HashMap<String, Object>(hashMapA.size());
            for (String key : hashMapA.keySet()) {
                hashMapB.put(key, hashMapA.get(key).toJavaObject());
            }
            return hashMapB;
        }
        if (this instanceof NSSet) {
            Set<NSObject> setA = ((NSSet)this).getSet();
            AbstractSet setB = setA instanceof LinkedHashSet ? new LinkedHashSet(setA.size()) : new TreeSet();
            for (NSObject o : setA) {
                setB.add(o.toJavaObject());
            }
            return setB;
        }
        if (this instanceof NSNumber) {
            NSNumber num = (NSNumber)this;
            switch (num.type()) {
                case 0: {
                    long longVal = num.longValue();
                    if (longVal > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE) {
                        return longVal;
                    }
                    return num.intValue();
                }
                case 1: {
                    return num.doubleValue();
                }
                case 2: {
                    return num.boolValue();
                }
            }
            return num.doubleValue();
        }
        if (this instanceof NSString) {
            return ((NSString)this).getContent();
        }
        if (this instanceof NSData) {
            return ((NSData)this).bytes();
        }
        if (this instanceof NSDate) {
            return ((NSDate)this).getDate();
        }
        if (this instanceof UID) {
            return ((UID)this).getBytes();
        }
        return this;
    }
}

